% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_expecvar.R
\name{mutate_expecvar}
\alias{mutate_expecvar}
\title{Add new expecteds and variances to an experience study}
\usage{
mutate_expecvar(
  .data,
  new_expected_rates,
  new_expecvar_prefix = "auto",
  measure_sets = guess_measure_sets(.data),
  amount_scalar = NULL,
  .by = NULL,
  .keep = c("all", "used", "unused", "none"),
  .before = NULL,
  .after = NULL
)
}
\arguments{
\item{.data}{A \code{\link[base:data.frame]{base::data.frame()}} that houses an experience study.}

\item{new_expected_rates}{A numeric vector to use as the expected probability for the study's event
of interest (i.e., policy lapse or insured death). This can be a column
in the dataset or a new numeric vector of length 1 or \code{nrow(.data)}.}

\item{new_expecvar_prefix}{A string to distinguish the new expecteds and variances columns in the
dataset. To overwrite existing expecteds and variances columns, use an
argument value of \code{NULL}, \code{character()}, or \code{''}. The default \code{'auto'} will
add a numeric prefix based on the previous names of expecteds/variances so
that names will remain unique.}

\item{measure_sets}{A (potentially named) list of measure sets. Only need to specify once if
chaining multiple \code{expstudy} functions as the \code{measure_sets} will be
passed as an attribute in results.}

\item{amount_scalar}{A numeric vector to use when determining amount-weighted expecteds and
variances. The function will determine whether or not the new
expecteds/variances are amount-weighted if the corresponding actuals in
the study have values greater than 1 (actuals that are not
amount-weighted, i.e., counts, should only be 0 or 1).}

\item{.by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{.keep}{Control which columns from \code{.data} are retained in the output. Grouping
columns and columns created by \code{...} are always kept.
\itemize{
\item \code{"all"} retains all columns from \code{.data}. This is the default.
\item \code{"used"} retains only the columns used in \code{...} to create new
columns. This is useful for checking your work, as it displays inputs
and outputs side-by-side.
\item \code{"unused"} retains only the columns \emph{not} used in \code{...} to create new
columns. This is useful if you generate new columns, but no longer need
the columns used to generate them.
\item \code{"none"} doesn't retain any extra columns from \code{.data}. Only the grouping
variables and columns created by \code{...} are kept.
}}

\item{.before, .after}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, control where new columns
should appear (the default is to add to the right hand side). See
\code{\link[dplyr:relocate]{relocate()}} for more details.}
}
\value{
An object of the same type as \code{.data}. The output has the following
properties:
\itemize{
\item Columns from \code{.data} will be preserved according to the \code{.keep} argument.
\item Existing columns that are modified by \code{...} will always be returned in
their original location.
\item New columns created through \code{...} will be placed according to the
\code{.before} and \code{.after} arguments.
\item The number of rows is not affected.
\item Columns given the value \code{NULL} will be removed.
\item Groups will be recomputed if a grouping variable is mutated.
\item Data frame attributes are preserved.
}
}
\description{
\code{mutate_expecvar()} uses a new expected rate for a decrement of interest and
adds a corresponding expected decrements column and corresponding variance
of expected decrements column. If there are already expecteds and variances
measures within the study dataset, either new, prefixed columns will be
added or the current expecteds and variances can be overwritten.
}
\section{Underlying Assumptions}{
This function was developed according to current industry practice relating
to experience study calculations. Some of the assumptions incorporated are
briefly outlined below.
\enumerate{
\item The experience study data is at a seriatim level where repeated
observations of multiple units can exist. For example, the study data can
contain experience for multiple policies over multiple calendar or policy
years.
\item Each decrement event can be described as a Bernoulli random variable with
expected rate of decrement equal to $p$. Furthermore, combining multiple
observation units with equal rates of decrement $p$ can be considered a
Binomial random variable with $n$ equal to the number of observation units.
\item Decrements are considered to be uniform between observations.
}

With these assumptions, new expecteds that are not amount-weighted are
calculated as the product of exposures and the expected decrement rate, new
variances are calculated as the product of the previously calculated new
expecteds and 1 minus the previously calculated new expecteds.
Amount-weighted expecteds and variances follow the prior calculations and
additionally multiply by the amount scalar and amount scalar squared,
respectively.

For a more detailed explanation of these methods used, please refer to the
\href{https://www.soa.org/globalassets/assets/Files/Research/2016-10-experience-study-calculations.pdf}{Society of Actuary's publication over experience study calculations}.
}

\section{Naming convention}{


\code{expstudy} uses a naming convention where some functions are prefixed by the
underling \code{dplyr} verb. The purpose of this is to associate the resulting
structure of the \code{expstudy} function with a very similar output as what the
\code{dplyr} function would produce. Note that the intention here is not replace
all \code{dplyr} use cases but instead add specific functionality to streamline
routine experience study analyses.
}

\examples{
mortexp |>
  dplyr::mutate(
    NEW_EXPECTED_MORT_RT = runif(n = nrow(mortexp))
  ) |>
  mutate_expecvar(
    new_expected_rates = NEW_EXPECTED_MORT_RT,
    new_expecvar_prefix = 'ADJ_',
    amount_scalar = FACE_AMOUNT
  )

}
