% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logicals.R
\name{\%e\%}
\alias{\%e\%}
\title{Element In Set Operator}
\usage{
e1 \%e\% e2
}
\arguments{
\item{e1}{The values to be operated on, on the left hand side}

\item{e2}{A character string containing set notation style
defined ranges on the real number line. Separate sets with the
\dQuote{&} or \dQuote{|} operator for AND or OR.}
}
\value{
a logical vector
}
\description{
This operator allows use of set notation style definitions
}
\examples{

c(-1, 0, 1, 9, 10, 16, 17, 20) \%e\% "(-Inf, 0) | [1, 9) | [10, 16] | (17, Inf]"
table(mtcars$mpg \%e\% "(0, 15.5) | [22.8, 40)")
table(mtcars$mpg \%e\% "(0, 15) | [16, 18] | [30, 50)")
c(-1, 0, 1) \%e\% "(-Inf, Inf) & [0, 0] | [1, 1]"

z <- max(mtcars$mpg)
table(mtcars$mpg \%e\% "(-Inf, z)")

## clean up
rm(z)
}
\keyword{logical}
\keyword{operators}
