% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmgpd.R
\name{fmgpd}
\alias{fmgpd}
\title{MGPD Estimation}
\usage{
fmgpd(x, it, k, start = NULL, var = NULL, prior = NULL, thin = 1, burn = 0)
}
\arguments{
\item{x}{A vector of positive observations.}

\item{it}{Number of iterations of the algorithm.}

\item{k}{number of mixture components for the bulk. Must be either 2, 3, or 4.}

\item{start}{A list of starting parameter values.}

\item{var}{A list of starting proposal variance.}

\item{prior}{A list of hyperparameters for the prior distribution.}

\item{thin}{Thinning interval.}

\item{burn}{Burn-in.}
}
\value{
\code{fmgpd} returns a list with three elements: \itemize{
\item \code{chain}: a matrix of size (\code{it} - \code{burn})/\code{thin}\eqn{\times}5, reporting in each column the posterior sample for each parameter.
\item \code{var}: a matrix of size \code{it}\eqn{\times}5 reporting the variance of the proposal distribution for each parameter.
\item \code{data}: the dataset used for estimation.
}
}
\description{
Fit of the MGPD model using an MCMC algorithm.
}
\details{
Estimation of the MGPD is carried out using an adaptive block Metropolis-Hastings algorithm. As standard, the user needs to specify the data to use during estimation, the number of mixture components for the bulk, the number of iterations of the algorithm, the burn-in period (by default equal to zero) and the thinning interval (by default equal to one).
To run the algorithm it is also needed the choice of the starting values, the starting values of the proposal variances, and the parameters of the prior distribution. If not provided, these are automatically set as follows:
\itemize{
\item \emph{starting values}: \eqn{u} is chosen by the function \code{ithresh} of the \code{threshr} package; \eqn{\xi} and \eqn{\sigma} are chosen by the \code{fpot} function of \code{evd} for data over the threshold; \eqn{\mu} and \eqn{\eta} are chosen as estimates of the \code{gammamixEM} function from the \code{mixtools} package; \eqn{w} is chosen as the vector with entries \eqn{1/k}.
\item \emph{variances}: variances for \eqn{\sigma} and \eqn{u} are chosen as the standard deviation of the normal distribution whose 0.01 quantile is equal to 0.9 times the starting value of the associated parameter. The parameters \eqn{\mu_i} and \eqn{\eta_i} are sampled jointly and the proposal variance is chosen using the same method as for \eqn{\sigma} with respect to the parameter \eqn{\mu}. The proposal variance for \eqn{w} is 0.1 and the proposal variance for \eqn{\xi} is 0.1 if negative and 0.25 if positive.
\item \emph{prior distributions}: the prior distribution for \eqn{\xi} and \eqn{\sigma} is the objective prior \deqn{p(\xi,\sigma) = \sigma^{-1}(1+\xi)^{-1}(1+2\xi)^{-1/2}.} The prior for the threshold \eqn{u} is Normal with mean chosen as for the starting values and the standard deviation is chosen so that the 0.05 quantile of the prior is equal to the median of the data. The priors for the parameters \eqn{\mu_i} and \eqn{\eta_i} are Gammas with mean chosen as for the starting values and shapes equal to 0.001 so to give high prior variances. The prior for the weigths is the non-informative Dirichlet with parameter 1.
}

The user can also select any of the three inputs above. \itemize{
\item The starting values \code{start} must be a list with entries \code{xi}, \code{sigma}, \code{u}, \code{mu}, \code{eta} and \code{w}. The length of  \code{mu}, \code{eta} and \code{w} must be \code{k}.
\item The variances \code{var} must be a list with entries \code{xi}, \code{sigma}, \code{u}, \code{mu} and  \code{w}. The length of \code{mu} must be \code{k}.
\item The prior \code{prior} must be a list with entries \code{u}, \code{mu_mu}, \code{mu_eta}, \code{eta_mu} and \code{eta_eta}.  \code{u} gives the mean and the standard deviation of the Normal prior for \eqn{u}. The vectors of length \code{k}, \code{mu_mu} and \code{eta_mu} give the prior means of \eqn{\mu} and \eqn{\eta}, whilst \code{mu_eta} and \code{eta_eta} give their prior shapes.}
}
\examples{
\donttest{
data(rainfall)
## Small number of iterations and burn-in for quick execution
model1 <- fmgpd(rainfall, k = 2, it = 250, burn = 50, thin = 25)
start <- list(xi = 0.2, sigma = 2, u = 10, mu = c(2,5), eta = c(2,2) , w = c(0.4,0.6))
var <- list(xi = 0.01, sigma = 1, u = 3, mu = c(3,3), w = 0.01)
prior <- list(u = c(22,5), mu_mu = c(2,5), mu_eta = c(0.01,0.01),
         eta_mu = c(3,3),eta_eta = c(0.01,0.01))

model2 <- fmgpd(rainfall, k= 2, it = 250, start = start, var =var, prior = prior)
}

}
\references{
Behrens, Cibele N., Hedibert F. Lopes, and Dani Gamerman. "Bayesian analysis of extreme events with threshold estimation." Statistical Modelling 4.3 (2004): 227-244.

do Nascimento, Fernando Ferraz, Dani Gamerman, and Hedibert Freitas Lopes. "A semiparametric Bayesian approach to extreme value estimation." Statistics and Computing 22.2 (2012): 661-675.
}
\seealso{
\code{\link{fggpd}}, \code{\link{mgpd}}
}
