% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_summaries}
\alias{plot_summaries}
\alias{plot.quant}
\alias{plot.return_level}
\alias{plot.VaR}
\alias{plot.ES}
\title{Plot Methods for Summaries}
\usage{
\method{plot}{quant}(x, ylim = NULL, ...)

\method{plot}{return_level}(x, ylim = NULL, ...)

\method{plot}{VaR}(x, ylim = NULL, ...)

\method{plot}{ES}(x, ylim = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{quant}, \code{ES}, \code{return_level} or \code{VaR}.}

\item{ylim}{limits of the y-axis.}

\item{...}{additional parameters  for compatibility.}
}
\value{
Appropriate plots for quantities computed with \code{extrememix}.
}
\description{
Plotting methods for objects created with \code{quant}, \code{ES}, \code{return_level} or \code{VaR}.
}
\details{
Two types of plot can be output: either a line plot in the case the functions \code{quant}, \code{ES}, \code{return_level} or \code{VaR} where called with more than one value for the input \code{values}, or an histogram otherwise.
}
\examples{
plot(return_level(rainfall_ggpd)) ## for line plot
plot(return_level(rainfall_ggpd, values = 100)) ## for histogram


}
