% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{amd}
\alias{amd}
\title{Twelve years neovascular AMD survival data}
\format{
A data frame (tibble) with 6696 rows and 23 variables:
\describe{
\item{patID}{anonymised patient number}
\item{sex}{gender of patient (m = male, f = female)}
\item{age}{age at initiation of anti-VEGF therapy (50-59 years,
60-69 years, 70-79 years, 80 years and above)}
\item{avdays_induc}{arithmetical average of interval between injections in induction
phase in days}
\item{ethnicity}{ethnicity of patient: asian (South East Asian), caucasian
Afro Caribbean, Mixed, unknown_other)}
\item{loaded}{induction phase was appropriately completed within 90 days (TRUE)
or not (FALSE)}
\item{time}{days following initiation of anti-VEGF therapy}
\item{injgiven}{whether injection was given at appointment time or
not (TRUE = injections given , FALSE = injection not given)}
\item{va}{visual acuity at time point in early treatment diabetic
retinopathy study letter score}
\item{regimen}{anti-VEGF drug given is ranibizumab only or aflibercept only}
\item{pre2013}{ anti-VEGF therapy initiated before October 2013 (TRUE) or after (FALSE)
i.e. before or after the introduction of aflibercept, respectively}
}
}
\source{
\url{https://doi.org/10.5061/dryad.nvx0k6dqg}
}
\usage{
data("amd")
}
\description{
To explore potential utility of survival analysis techniques for retrospective
clinical practice visual outcomes in a retrospective cohort study with
12-year observation period.
}
\section{Study setting and design}{

Of 10,744 eyes with neovascular AMD receiving anti-VEGF therapy between
October 2008 and February 2020, 7802 eyes met study criteria
(treatment-naïve, first-treated eyes starting anti-VEGF therapy).
Institution:	 Moorfields Eye Clinic, London, UK
Approval was granted by the Institutional Review Board of the hospital
(ROAD17/031). The study complied with the Declaration of Helsinki
}

\section{Data source}{

All clinical information at Moorfields Eye Hospital is recorded within an
electronic medical record (EMR) application (OpenEyes Foundation, London, UK).
A SQL database (SQL Server Reporting Service, Microsoft Corporation, Richmond, USA)
containing all the information from the EMR is in place and regular updates
are performed overnight to keep the data warehouse up-to-date.
VA is reported in ETDRS letter score (and categories for ETDRS < 1).
The highest value (independent of measurement method)
available at each visit was chosen.
}

\section{Data}{

Types of data: de-identified human subjects data
Information governance authorised Moorfields Eye Clinic 19/07/2018.
age not provided as a continuous variable as in original analysis
to facilitate de-identification
}

\seealso{
Associated publication:
„Insights from survival analyses during 12 years of anti-vascular endothelial
growth factor therapy for neovascular age-related macular degeneration“
\url{https://doi.org/10.1001/jamaophthalmol.2020.5044}
}
\keyword{datasets}
