% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dme}
\alias{dme}
\title{Real life data of patients with diabetic macular edema}
\format{
A data frame (tibble) with 40281 rows and 8 variables:
\describe{
\item{patID}{Anonymized patient identifier}
\item{sex}{Sex of patient (m = male, f = female)}
\item{ageStrat}{Age (years) at day of first appointment, stratified.
Factor! Labels are constructed using "(a,b]" interval notation, e.g., "(60,70]"
means x > 60 & x<= 70}
\item{ethnicity}{Ethnicity of patient following the categories from the
UK ETHNIC CATEGORY CODE 2001. (asian = Asian or Asian British,
white = White, black = Black or Black British,
mixed = Mixed, other = Other ethnic group, unknown = Unknown)}
\item{eye}{Left or right eye of patient (r = right, l = left)}
\item{va}{Visual acuity in Early Treatment Diabetic Retinopathy Study (ETDRS) letters}
\item{time}{Time in days following baseline i.e. injection number 1}
\item{inj}{Injection given or not (TRUE = injection given, FALSE = no injection given)}
}
}
\source{
\url{https://doi.org/10.5061/dryad.pzgmsbcfw}
}
\usage{
data("dme")
}
\description{
A dataset containing anonymized real life human subjects data on eyes with
diabetic macular edema (DME), which underwent intravitreal
anti-VEGF therapy with ranibizumab and/or aflibercept.
Data was accessed on the 3rd July 2020.
}
\section{Missing values}{

There are 18 missing visual acuity entries in this data set. They result
from data entry errors (ETDRS values above 100) in the original
medical health records. Unfortunately, the correct VA value could not be
retrieved and it was decided to assign missing values to those measurements.
}

\section{Study setting and design}{

Study setting and design: This study is a retrospective cohort study of
diabetic patients treated for DMO by anti-VEGF at a tertiary referral center -
Moorfields Eye Hospital NHS Foundation Trust, London, UK.
Approval was granted by the Institutional Review Board of the hospital
(ROAD17/031) - Audit registration was completed (MEH-233).
The study complied with the Declaration of Helsinki and STROBE guidelines
for the reporting of cohort studies.
}

\section{Data source}{

All clinical information at Moorfields Eye Hospital is recorded within an
electronic medical record (EMR) application (OpenEyes Foundation, London, UK).
A SQL database (SQL Server Reporting Service, Microsoft Corporation, Richmond, USA)
containing all the information from the EMR is in place and regular updates
are performed overnight to keep the data warehouse up-to-date.
VA is reported in ETDRS letter score. The highest value (independent of
measurement method) available at each visit was chosen.
}

\section{Participants}{

A data-warehouse query for patients that received one IVI for DMO
(between March 2013 and October 2018) resulted in 3226 unique eyes from
2368 patients. Exclusion criteria were those that:
(i) suffered from
macular oedema secondary to other conditions than diabetes;
(ii) under 18 years old;
(iii) received fewer than 3 IVI;
(iv) received bevacizumab, dexamethasone intravitreal implant,
or fluocinolone acetonide intravitreal implant; leaving 2614 eyes of 1964
patients taken forward for analysis.
}

\seealso{
Scientific article to which this data set was supplement:
\url{https://doi.org/10.1038/s41433-020-1048-0}
}
\keyword{datasets}
