% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-management.R
\name{export_ecm}
\alias{export_ecm}
\alias{import_ecm}
\title{Saving and loading fitted ECM models}
\usage{
export_ecm(x = NULL, file = stop("'file' must be specified"), verb = TRUE)

import_ecm(file = NULL, verb = TRUE)
}
\arguments{
\item{x}{Name of ECM model to be exported. \code{class(x)} should be either \code{"cECM"} or \code{"BayesECM"}.}

\item{file}{Character string containing absolute or relative path of \verb{*.rda} file to be exported or imported.}

\item{verb}{Logical indicating if a message indicating success should be printed to the console.}
}
\value{
Saves file or imports file into global environment.
}
\description{
\code{export_ecm()} saves an ECM model fit to training data for later use. The object can be the output of the \code{\link[=cECM]{cECM()}} or \code{\link[=BayesECM]{BayesECM()}} functions.  Object saved in user specified location.

\code{import_ecm()} loads a previously exported ECM model into the global environment.
}
\examples{

x <- pval_gen(sims = 20, pwave.arrival = list(optim.starts = 5))
pval_cat <- cECM(x = x, transform = TRUE)

export_ecm(x = pval_cat, file = "example-ecm.rda", verb = FALSE)

reload_pval_cat <- import_ecm(file = "example-ecm.rda")

## The below code shouldn't be used,
## it deletes the file created during the example

unlink("example-ecm.rda")



}
