% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-sim.R
\name{pval_gen}
\alias{pval_gen}
\title{Simulate p-values from earthquakes and explosions}
\usage{
pval_gen(
  sims = 100,
  grid.dim = c(800, 800, 30),
  seismometer = list(N = 100, max.depth = 2, Sig = NULL, sig.draws = c(15, 2)),
  explosion = list(max.depth = 5, prob = 0.4),
  pwave.arrival = list(H0 = 5, V = 5.9, optim.starts = 15),
  first.polarity = list(read.err = 0.95)
)
}
\arguments{
\item{sims}{numeric stipulating the number of individual events to generate.}

\item{grid.dim}{numeric 3-vector providing the extent of the coordinate system in \code{c(X,Y,Z)} to be used in km.}

\item{seismometer}{list stipulating variables relating to the seismometers. Providing an incomplete list reverts to the default values.  List elements are:
\itemize{
\item \code{N} a numeric stipulating the number of seismometers
\item \code{max.depth} is a numeric providing the maximum depth for a seismometer location in km
\item \code{Sig} supplying a numeric vector of length \code{N} to this argument will stipulate the variance in the error in observed arrival time of each of the \code{N} seismometers.
\item \code{sig.draws}  a numeric 2-vector, if \code{Sig} is not provided the variance in arrival time at each station is drawn from \code{\link[MCMCpack:InvGamma]{MCMCpack::rinvgamma()}} using \code{shape = sig.draws[1]} and \code{scale = sig.draws[2]}.
}}

\item{explosion}{list stipulating variables regarding a detonation event. Providing an incomplete list reverts to the default values.  List elements are:
\itemize{
\item \code{max.depth} is a numeric providing the maximum depth of an explosion in km
\item \code{prob}  is the probability of an explosion, controlling the fraction of events which are explosions.  Value provided must be in the interval \eqn{[0,1]}
}}

\item{pwave.arrival}{list stipulating variables regarding the depth from p-wave arrival discriminant. Providing an incomplete list reverts to the default values.  List elements are:
\itemize{
\item \code{H0} a numeric providing the value of depth in km for the null hypothesis
\item \code{V}  a numeric stipulating the velocity of p-waves in km.  Used for simulating p-wave arrival times as an argument of \code{\link[=time_fn]{time_fn()}}.
\item \code{optim.starts} number of \code{\link[stats:optim]{stats::optim()}} starts used to maximize likelihood of event location.
}}

\item{first.polarity}{list stipulating variables regarding the depth from the polarity of first motion discriminant.  List elements are:
\itemize{
\item \code{read.err}  numeric in the interval  \eqn{[0,1]} providing the probability of an error in reading the true first polarity.
}}
}
\value{
A data frame, with the number of rows equal to \code{sims}.  Columns contain the p-values observed for each simulation along with the true event type.
}
\description{
p-values are simulated for depth and first polarity discriminants to use in testing classification models.
}
\details{
Methods are adapted from the discriminants listed in \insertCite{anderson2007mathematical}{ezECM}.
}
\section{Depth Discriminant}{
The equation below is used to model p-wave arrival time \eqn{t_i} at seismometer \eqn{i}.

\deqn{t_i = t_0 + T(S_i, S_0) + \epsilon_i}

Where \eqn{t_0} is the time of the event, \eqn{T()} is a function modeling the arrival time (in this case \link{time_fn}), \eqn{S_i} is the location of seismometer \eqn{i}, \eqn{S_0} is the location of the event, and \eqn{\epsilon_i} is normally distributed error with known variance \eqn{\sigma^2_i}.  Given \code{N} seismometers, the MLE of the event time \eqn{\hat{t}_0} can be solved as the following:

\deqn{\hat{t}_0 = \frac{\mathrm{tr}\left(\Sigma^{-1} T_i\right) - \mathrm{tr}\left(\Sigma^{-1}T(S,S_0)\right)}{\mathrm{tr}(\Sigma^{-1})}}

Where \eqn{\mathrm{tr}()} is the matrix trace operation, \eqn{\Sigma} is a matrix containing the elements of each \eqn{\sigma_i^2} on the diagonal, \eqn{T_i} is a diagonal matrix containing each \eqn{t_i}, and \eqn{T(S, S_0)} is a diagonal matrix containing each \eqn{T(S_i, S_0)}.  This result is then plugged back into the first equation, which is then used in a normal likelihood function.  Derivatives are taken of the likelihood so that a fast gradient based approch can be used to find the maximum likelihood estimate (MLE) of \eqn{S_0}.

The remainder of the calculation of the p-value is consistent with the \emph{Depth from P-Wave Arrival Times} section of \insertCite{anderson2007mathematical}{ezECM}.  First note \eqn{S_0} is equal to the 3-vector \eqn{(X_0, Y_0, Z_0)^{\top}}.  Given the null hypothesis for the depth of \eqn{\mathrm{H}_0: Z_0 \leq z_0}, the MLE \eqn{(\hat{X}_0, \hat{Y}_0)} given \eqn{Z_0 = z_0} is found.  The sum of squared errors (SSE) is calculated as follows:

\deqn{\mathrm{SSE}(S_0, t_0) = \sum_{i = 1}^N\left(\frac{t_i - t_0 - T(S_i, S_0)}{\sigma_i}\right)^2}

If \eqn{\mathrm{H}_0} is true then the following statistic has a central \eqn{F} distribution with \eqn{1} and \eqn{N-4} degrees of freedom.

\deqn{F_{1,N-4} = \frac{\mathrm{SSE}(S_0, t_0|Z_0 = z_0) - \mathrm{SSE}(S_0, t_0)}{\mathrm{SSE}(S_0, t_0)}}

Because the test has directionality, the \eqn{F} statistic is then converted to a \eqn{T} statistic as such:

\deqn{T_{N-4} = \mathrm{sign}(\hat{Z}_0 - z_0)\sqrt{F_{1,n-4}}}

This \eqn{T} statistic is then used to compute the p-value
}

\section{Polarity of First Motion}{
Under the null hypothesis that the event is an explosion, (and therefore the true polarity of first motion is always one), the error rate for mistakenly identifying the polarity of first motion is stipulated as the argument \code{first.polarity$read.err}.  For an error rate of \eqn{\theta} the p-value can then be calculated as follows:

\deqn{\sum_{i = 0}^n {N \choose i} \theta^i(1-\theta)^{N-i}}

Where \eqn{n} is the number of stations where a positive first motion was observed, and \eqn{N} is the total number of stations.
}

\examples{

test.data <- pval_gen(sims = 5)


}
\references{
\insertAllCited{}
}
