% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{IRF.VAR}
\alias{IRF.VAR}
\title{Calculate impulse responses from a fable model}
\usage{
\method{IRF}{VAR}(x, new_data, specials, impulse = NULL, orthogonal = FALSE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{new_data}{A tsibble containing the time points and exogenous regressors to produce forecasts for.}

\item{specials}{(passed by \code{\link[fabletools:forecast]{fabletools::forecast.mdl_df()}}).}

\item{impulse}{A character string specifying the name of the variable that is shocked (the impulse variable).}

\item{orthogonal}{If TRUE, orthogonalised impulse responses will be computed.}

\item{...}{Other arguments passed to methods}
}
\description{
Simulates future paths from a dataset using a fitted model. Innovations are
sampled by the model's assumed error distribution. If \code{bootstrap} is \code{TRUE},
innovations will be sampled from the model's residuals. If \code{new_data}
contains the \code{.innov} column, those values will be treated as innovations.
}
