% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitFfmDT.R
\name{specFfm}
\alias{specFfm}
\title{Specifies the elements of a fundamental factor model}
\usage{
specFfm(
  data,
  asset.var,
  ret.var,
  date.var,
  exposure.vars,
  weight.var = NULL,
  addIntercept = FALSE,
  rob.stats = FALSE
)
}
\arguments{
\item{data}{data.frame of the balanced panel data containing the variables
\code{asset.var}, \code{ret.var}, \code{exposure.vars}, \code{date.var} and
optionally, \code{weight.var}.}

\item{asset.var}{character; name of the variable  for asset names.}

\item{ret.var}{character; name of the variable for asset returns.}

\item{date.var}{character; name of the variable containing the dates
coercible to class \code{Date}.}

\item{exposure.vars}{vector; names of the variables containing the
fundamental factor exposures.}

\item{weight.var}{character; name of the variable containing the weights
used when standardizing style factor exposures. Default is \code{NULL}. See
Details.}

\item{addIntercept}{logical; If \code{TRUE}, intercept is added in
the exposure matrix. Default is \code{FALSE},}

\item{rob.stats}{logical; If \code{TRUE}, robust estimates of covariance,
correlation, location and univariate scale are computed as appropriate (see
Details). Default is \code{FALSE}.}
}
\value{
an object of class ffmSpec holding the details of the analysis
}
\description{
Factor models have a few parameters that describe how the 
fitting is done.  This function summarizes them and returns a spec object for
cross-sectional regressions.  It also preps the data. An object of class 
\code{"ffmSpec"} is returned.
}
\examples{
\donttest{
library(PCRA)

dateRange <- c("2006-01-31","2010-12-31")
stockItems <-  c("Date", "TickerLast",  "Return","Sector")
factorItems <- c("BP","Beta60M","PM12M1M")
facDatIT <- selectCRSPandSPGMI("monthly",
                               dateRange = dateRange, 
                               stockItems = stockItems, 
                               factorItems = factorItems, 
                               outputType = "data.table")
asset.var="TickerLast" 
ret.var="Return" 
date.var = "Date"
exposure.vars= c("BP","Beta60M","PM12M1M")
spec1 <- specFfm(data = facDatIT,asset.var = asset.var, ret.var = ret.var, 
                 date.var = date.var, exposure.vars = exposure.vars,weight.var = NULL,
                 addIntercept = TRUE, rob.stats = FALSE)
spec1$exposure.vars

#lag the exposures
spec1 <- lagExposures(spec1)
# standardize the exposures Cross-Sectionally
spec1 <- standardizeExposures(spec1, Std.Type = "CrossSection") 
# fit the model
mdlFit <- fitFfmDT(spec1) 
class(mdlFit)
class(mdlFit$reg.listDT)
}
}
