% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paFm.R
\name{paFm}
\alias{paFm}
\title{Compute cumulative mean attribution for factor models}
\usage{
paFm(fit, ...)
}
\arguments{
\item{fit}{an object of class \code{tsfm}, \code{sfm} or \code{ffm}.}

\item{...}{other arguments/controls passed to the fit methods.}
}
\value{
The returned object is of class \code{"pafm"} containing
\item{cum.ret.attr.f}{N X K matrix of cumulative return attributed to
factors.}
\item{cum.spec.ret}{length-N vector of cumulative specific returns.}
\item{attr.list}{list of time series of attributed returns for every
portfolio.}
}
\description{
Decompose total returns into returns attributed to factors and 
specific returns. An object of class \code{"pafm"} is generated, with 
methods for generic functions \code{plot}, \code{summary} and \code{print}.
}
\details{
Total returns can be decomposed into returns attributed to factors 
and specific returns. \cr \eqn{R_t = \sum  b_k * f_kt + u_t, t=1...T} \cr
\code{b_k} is exposure to factor k and \code{f_kt} is factor k's return at 
time t. The return attributed to factor k is \code{b_k * f_kt} and specific 
return is \code{u_t}.
}
\examples{
data(managers, package = 'PerformanceAnalytics')
fit <- fitTsfm(asset.names=colnames(managers[, (1:6)]), 
               factor.names=c("EDHEC LS EQ","SP500 TR"), 
               data=managers)
# without benchmark
paFm(fit)

}
\references{
Grinold, R. and Kahn, R. (1999) Active Portfolio Management: A 
Quantitative Approach for Producing Superior Returns and Controlling Risk. 
McGraw-Hill.
}
\seealso{
\code{\link{fitTsfm}}
for the factor model fitting functions.

The \code{pafm} methods for generic functions: 
\code{\link{plot.pafm}}, \code{\link{print.pafm}} and 
\code{\link{summary.pafm}}.
}
\author{
Yi-An Chen and Sangeetha Srinivasan
}
