% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iv_factorial.R
\name{iv_factorial}
\alias{iv_factorial}
\title{IV Estimation of 2^K Factorial Design}
\usage{
iv_factorial(formula, data, subset, method = "lm", level = 0.95)
}
\arguments{
\item{formula}{formula specification of the factorial design with
noncompliance. The right-hand side of the formula should have
two components separated by the \code{|} symbol, with the first
component containing the K binary treatment variables and the
second component containing the K binary instruments associated
with each treatment variable. The order of the variables in the
formula must match.}

\item{data}{A data.frame on which to apply the \code{formula}.}

\item{subset}{subset of the data to pass to estimation.}

\item{method}{character indiciating if the estimator should be
\code{"lm"} using the least squares approach (default) or
\code{"cmd"} to estimate via efficent minimum distance estimator.}

\item{level}{the confidence level required.}
}
\value{
A list of class \code{iv_factorial} that contains the following
components:
\item{rho}{vector of estimated compliance class
probabilities.}
\item{psi}{vector of the estimated conditional mean of the outcome
within the compliance classes.}
\item{vcov}{estimated asymptotic variance matrix of the combined
\code{rho}  and \code{psi} parameters.}
\item{pcafe_est}{vector of estimated main effects of each factor among
perfect compliers.}
\item{pcafe_se}{vector of estimated standard errors for the
estimated effects in \code{tau}.}
\item{pcafe_cis}{a matrix of confidence intervals for the PCAFE
estimates.}
\item{level}{the confidence level of the returned confience
intervals.}
}
\description{
Estimates principal stratum-specific effects and interactions in a
2^K factorial experiment
}
\details{
This function estimates treatment effects for 2^K factorial
experiments in the face of noncompliance on all factors. A
monotonicity assumption is assumed for both treatment-instrument
pairs, along with treatment exclusion. See Blackwell (2017) for
more details on those assumptions.

The procedure uses iterative generalized method of moments (GMM)
to  estimate both the proportions of each compliance class (also
known as principal strata) and the average potential outcomes
within those classes. It also provides estimates of several
one-way, joint, and interactive treatment effects within these
classes.

Under the above assumptions, the compliance classes are the
product of the compliance classes for each treatment-instrument
pair. For instance, \code{"cc"} is the class that would comply
with both treatments, \code{"ca"} is the class that would comply
with the first treatment and always take the second treatment, and
\code{"cn"} is the class that would comply with the first
treatment and never take the second treatment. Finally, note that
treatment effects are only well-defined for compliance classes for
which there is compliance on at least one treatment.
}
\examples{
data(newhaven)

out <- iv_factorial(turnout_98 ~ inperson + phone | inperson_rand
  + phone_rand, data = newhaven)

summary(out)

}
\references{
Matthew Blackwell (2017) Instrumental Variable Methods
for Conditional Effects and Causal Interaction in Voter
Mobilization Experiments, Journal of the American Statistical
Association, 112:518, 590-599,
\doi{10.1080/01621459.2016.1246363}

Matthew Blackwell and Nicole Pashley (2020) "Noncompliance in
Factorial Experiments." Working paper.
}
\author{
Matt Blackwell
}
