% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fairness_heatmap.R
\name{fairness_heatmap}
\alias{fairness_heatmap}
\title{Fairness heatmap}
\usage{
fairness_heatmap(x, scale = FALSE)
}
\arguments{
\item{x}{object of class \code{fairness_object}}

\item{scale}{logical, if \code{TRUE} metrics will be scaled to mean 0 and sd 1. Default \code{FALSE}}
}
\value{
\code{fairness_heatmap} object.

It is a list with following fields:
\item{heatmap_data}{ - \code{data.frame} with information about score for model and parity loss metric}
\item{matrix_model}{ - matrix used in dendogram plots}
\item{scale}{ - logical parameter passed to \code{fairness_heatmap}}
\item{label}{ - character, vector of model labels}
}
\description{
Create \code{fairness_heatmap} object to compare both models and metrics.
If parameter \code{scale} is set to \code{TRUE} metrics will be scaled to median = 0 and sd = 1.
If NA's appear heatmap will still plot, but with gray area where NA's were.
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) - 1

lm_model <- glm(Risk ~ .,
  data = german,
  family = binomial(link = "logit")
)

rf_model <- ranger::ranger(Risk ~ .,
  data = german,
  probability = TRUE,
  num.trees = 200,
  num.threads = 1
)

explainer_lm <- DALEX::explain(lm_model, data = german[, -1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
  protected = german$Sex,
  privileged = "male"
)

# same explainers with different cutoffs for female
fobject <- fairness_check(explainer_lm, explainer_rf, fobject,
  protected = german$Sex,
  privileged = "male",
  cutoff = list(female = 0.4),
  label = c("lm_2", "rf_2")
)


fh <- fairness_heatmap(fobject)

plot(fh)
}
