% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataComputationHyperparameters.R
\name{export_hyperparameters}
\alias{export_hyperparameters}
\alias{export_hyperparameters,familiarCollection-method}
\alias{export_hyperparameters,ANY-method}
\title{Extract and export model hyperparameters.}
\usage{
export_hyperparameters(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  export_collection = FALSE,
  ...
)

\S4method{export_hyperparameters}{familiarCollection}(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  export_collection = FALSE,
  ...
)

\S4method{export_hyperparameters}{ANY}(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  export_collection = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{familiarCollection} object, or other other objects from which
a \code{familiarCollection} can be extracted. See details for more information.}

\item{dir_path}{Path to folder where extracted data should be saved. \code{NULL}
will allow export as a structured list of data.tables.}

\item{aggregate_results}{Flag that signifies whether results should be
aggregated for export.}

\item{export_collection}{(\emph{optional}) Exports the collection if TRUE.}

\item{...}{
  Arguments passed on to \code{\link[=as_familiar_collection]{as_familiar_collection}}
  \describe{
    \item{\code{familiar_data_names}}{Names of the dataset(s). Only used if the \code{object}
parameter is one or more \code{familiarData} objects.}
    \item{\code{collection_name}}{Name of the collection.}
  }}
}
\value{
A data.table (if \code{dir_path} is not provided), or nothing, as all data
is exported to \code{csv} files. In case of the latter, hyperparameters are
summarised.
}
\description{
Extract and export model hyperparameters from models in a
familiarCollection.
}
\details{
Data, such as model performance and calibration information, is
usually collected from a \code{familiarCollection} object. However, you can also
provide one or more \code{familiarData} objects, that will be internally
converted to a \code{familiarCollection} object. It is also possible to provide a
\code{familiarEnsemble} or one or more \code{familiarModel} objects together with the
data from which data is computed prior to export. Paths to the previous
files can also be provided.

All parameters aside from \code{object} and \code{dir_path} are only used if \code{object}
is not a \code{familiarCollection} object, or a path to one.

Many model hyperparameters are optimised using sequential model-based
optimisation. The extracted hyperparameters are those that were selected to
construct the underlying models (\code{familiarModel} objects).
}
