% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataComputationRiskStratificationInfo.R
\name{export_risk_stratification_info}
\alias{export_risk_stratification_info}
\alias{export_risk_stratification_info,familiarCollection-method}
\alias{export_risk_stratification_info,ANY-method}
\title{Extract and export cut-off values for risk group stratification.}
\usage{
export_risk_stratification_info(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  export_collection = FALSE,
  ...
)

\S4method{export_risk_stratification_info}{familiarCollection}(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  export_collection = FALSE,
  ...
)

\S4method{export_risk_stratification_info}{ANY}(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  export_collection = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{familiarCollection} object, or other other objects from which
a \code{familiarCollection} can be extracted. See details for more information.}

\item{dir_path}{Path to folder where extracted data should be saved. \code{NULL}
will allow export as a structured list of data.tables.}

\item{aggregate_results}{Flag that signifies whether results should be
aggregated for export.}

\item{export_collection}{(\emph{optional}) Exports the collection if TRUE.}

\item{...}{
  Arguments passed on to \code{\link[=as_familiar_collection]{as_familiar_collection}}
  \describe{
    \item{\code{familiar_data_names}}{Names of the dataset(s). Only used if the \code{object}
parameter is one or more \code{familiarData} objects.}
    \item{\code{collection_name}}{Name of the collection.}
  }}
}
\value{
A data.table (if \code{dir_path} is not provided), or nothing, as all data
is exported to \code{csv} files.
}
\description{
Extract and export cut-off values for risk group stratification
by models in a familiarCollection.
}
\details{
Data is usually collected from a \code{familiarCollection} object.
However, you can also provide one or more \code{familiarData} objects, that will
be internally converted to a \code{familiarCollection} object. It is also
possible to provide a \code{familiarEnsemble} or one or more \code{familiarModel}
objects together with the data from which data is computed prior to export.
Paths to the previous files can also be provided.

All parameters aside from \code{object} and \code{dir_path} are only used if \code{object}
is not a \code{familiarCollection} object, or a path to one.

Stratification cut-off values are determined when creating a model, using
one of several methods set by the \code{stratification_method} parameter. These
values are then used to stratify samples in any new dataset. The available
methods are:
\itemize{
\item \code{median} (default): The median predicted value in the development cohort
is used to stratify the samples into two risk groups.
\item \code{fixed}: Samples are stratified based on the sample quantiles of the
predicted values. These quantiles are defined using the
\code{stratification_threshold} parameter.
\item \code{optimised}: Use maximally selected rank statistics to determine the
optimal threshold (Lausen and Schumacher, 1992; Hothorn et al., 2003) to
stratify samples into two optimally separated risk groups.
}
}
\references{
\enumerate{
\item Lausen, B. & Schumacher, M. Maximally Selected Rank Statistics.
Biometrics 48, 73 (1992).
\item Hothorn, T. & Lausen, B. On the exact distribution of maximally selected
rank statistics. Comput. Stat. Data Anal. 43, 121–137 (2003).
}
}
