% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastOnlineCpt.r
\docType{methods}
\name{lastCptTest}
\alias{lastCptTest}
\alias{lastCptTest,fastOnlineCpt-method}
\title{Return the last result of the changepoint test performed with the function "checkCpt" as a vector.}
\usage{
lastCptTest(obj)

\S4method{lastCptTest}{fastOnlineCpt}(obj)
}
\arguments{
\item{obj}{An object of the class "fastOnlineCpt".}
}
\value{
A 5-dimensional vector containing the number of the test, the value of the Z-statistic, the p-value, the available testing level, and the changepoint location if a changepoint has been detected or NA otherwise. If no previous test has been performed, NA is returned.
}
\description{
Return the last result of the changepoint test performed with the function "checkCpt" as a vector.
}
\examples{
library(fastOnlineCpt)
alpha <- 0.01
halfspent <- 100
spending_sequence <- function(n) { (n/(n+halfspent) - (n-1)/(n-1+halfspent)) * alpha }
obj <- fastOnlineCpt(spending_sequence)
p <- 10
n <- 50
data <- matrix(rnorm(p*n,mean=0),ncol=n)
obj <- addData(obj,data)
obj <- checkCpt(obj)
print(lastCptTest(obj))
data <- matrix(rnorm(p*n,mean=1),ncol=n)
obj <- addData(obj,data)
obj <- checkCpt(obj)
print(lastCptTest(obj))

}
\references{
Hahn, G. (2021). Online multivariate changepoint detection with type I error control and constant time/memory updates per series. Under review.
}
