% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_comparison.r
\name{Compare,GRaster,GRaster-method}
\alias{Compare,GRaster,GRaster-method}
\alias{Compare-methods}
\alias{Compare,logical,GRaster-method}
\alias{Compare,GRaster,logical-method}
\alias{Compare,numeric,GRaster-method}
\alias{Compare,GRaster,numeric-method}
\alias{Compare,GRaster,integer-method}
\alias{Compare,integer,GRaster-method}
\alias{Compare,GRaster,character-method}
\alias{Compare,character,GRaster-method}
\alias{Compare,GRegion,GRegion-method}
\title{Compare-methods operations on GRasters and GRegions}
\usage{
\S4method{Compare}{GRaster,GRaster}(e1, e2)

\S4method{Compare}{logical,GRaster}(e1, e2)

\S4method{Compare}{GRaster,logical}(e1, e2)

\S4method{Compare}{numeric,GRaster}(e1, e2)

\S4method{Compare}{GRaster,numeric}(e1, e2)

\S4method{Compare}{GRaster,integer}(e1, e2)

\S4method{Compare}{integer,GRaster}(e1, e2)

\S4method{Compare}{GRaster,character}(e1, e2)

\S4method{Compare}{character,GRaster}(e1, e2)

\S4method{Compare}{GRegion,GRegion}(e1, e2)
}
\arguments{
\item{e1, e2}{Values depend on the type of comparison:
\itemize{
\item Comparing \code{GRaster}s to logical, numeric, character values: \code{e1} and \code{e2} can be any one of these. Comparison to a character string can be useful when using a categorical raster, in which case you can use something like \code{raster1 == "Wetlands"} to coerce all "wetland" cells to be 1 (TRUE) and all others 0 (FALSE) or \code{NA} (if it was originally \code{NA}).
\item Comparing a \code{GRegion} to another \code{GRegion}: \code{e1} and \code{e2} must be \code{GRegion}s!
}}
}
\value{
Comparing \code{GRaster}s: An "integer" \code{GRaster} with values of 0 (FALSE), 1 (TRUE), or \code{NA} (neither).

Comparing \code{GRegion}s: Output is logical.
}
\description{
You can do comparative operations on \code{GRaster}s using normal operators in \strong{R}: \code{<}, \code{<=}, \code{==}, \code{!=}, \code{>=}, and \code{>}. You can also use \code{\link[fasterRaster]{\%in\%}} for categorical \code{GRasters} (see \code{vignette("GRasters", package = "fasterRaster")}).

You can also compare two \code{GRegion}s using the \code{==} and \code{!=} operators. Most users of \strong{fasterRaster} will not have to work much with "regions" (see \code{vignette("regions", package = "fasterRaster")}), so can ignore this functionality. \code{GRegion}s are the same if they have the same coordinate reference system, location/project and mapset (see \code{vignette("projects_mapsets", package = "fasterRaster")}), topology (2D or 3D), extent, and resolution. If both are 3D, then they must also have the same vertical extent and number of depths.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster
elev <- fast(madElev)
elevs <- c(elev, elev, log10(elev) - 1, sqrt(elev))
names(elevs) <- c("elev1", "elev2", "log_elev", "sqrt_elev")

elev
elevs

# Comparisons
elev < 100
elev <= 100
elev == 100
elev != 100
elev > 100
elev >= 100

elev + 100 < 2 * elev

elevs > 10
10 > elevs

# logic
elev < 10 | elev > 200
elev < 10 | cos(elev) > 0.9

elev < 10 | TRUE
TRUE | elev > 200

elev < 10 | FALSE
FALSE | elev > 200

elev < 10 & cos(elev) > 0.9

elev < 10 & TRUE
TRUE & elev > 200

elev < 10 & FALSE
FALSE & elev > 200

}
}
