% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastliu.R
\name{liureg}
\alias{liureg}
\title{Fit a Liu Regression Coefficients Path}
\usage{
liureg(X, y, lambda = 1, scale = c("ulength", "unormal", "none"), ...)
}
\arguments{
\item{X}{The design matrix of features. \code{fastliu}
standardizes the data and includes an intercept term by default.}

\item{y}{The response vector.}

\item{lambda}{User-specified values of \code{lambda}. The default
value is 1, which corresponds to the least squares estimator.
A \code{lambda} sequence can be entered to generate multiple models.}

\item{scale}{Scaling type of the design matrix. \code{"ulength"} corresponds
to unit-length scaling. In this scaling the scaled design matrix is
in the form of a correlation matrix. \code{"unormal"} scales the features
to have unit variance (using \eqn{1/n} rather than \eqn{1/(n-1)} formula). \code{"none"}
does not make scaling and computations are done on centered features.}

\item{...}{Not used in this implementation.}
}
\value{
Fitted Liu regression object with the class of \code{liureg}
}
\description{
\code{liureg} fits coefficients paths for Liu regression models
over a grid of values for the regularization (biasing)
parameter \code{lambda}. The returned object is of class \code{liureg}.
}
\details{
The sequence of Liu regression models indexed by the tuning parameter.
\eqn{\lambda} are obtained by
\deqn{\hat{\boldsymbol{\beta}}^{liu}\left(\lambda\right)=
\left(\mathbf{X}^{T}\mathbf{X}+\mathbf{I}_{p}\right)^{-1}
\left(\mathbf{X}^{T}\mathbf{y}+\lambda\hat{\boldsymbol{\beta}}^{ls}\right),}
where \eqn{\hat{\boldsymbol{\beta}}^{ls}} is the ordinary least squares
estimator.To obtain the models, the singular value decomposition (SVD)
of the matrix \eqn{\mathbf{X}} is used. This SVD is done once and
is used to generate all models.

Explanatory variables in the design matrix are always centered
before fitting a model in the \code{fastliu} package.
For scaling, two options are possible:
unit-length and unit-normal scaling. In unit-length scaling,
the matrix of explanatory variables has correlation form.
In unit-normal scaling, the explanatory variables have zero
mean and unit variance.
Both Coefficient estimates based on the scaled data and
in original scale are presented.
The intercept of the model is not penalized and computed by
\eqn{\bar{y}-\bar{X}\boldsymbol{\hat{\beta}}_1}, where \eqn{\bar{X}}
is the row vector of the explanatory variables and \eqn{\boldsymbol{\hat{\beta}}_1}
is computed based on centered design matrix.

The returned \code{liureg} object
is used for statistical testing of Liu coefficients,
plotting method and computing the Liu regression related statistics.
}
\examples{
data("Hitters")
Hitters <- na.omit(Hitters)
X <- model.matrix(Salary ~ ., Hitters)[, -1]
y <- Hitters$Salary
lam <- seq(0, 1, 0.05)
liu.mod <- liureg(X, y, lam)
}
\seealso{
\code{\link[=coef]{coef()}}, \code{\link[=predict]{predict()}}, \code{\link[=summary]{summary()}}, \code{\link[=pressliu]{pressliu()}}, \code{\link[=residuals]{residuals()}}
}
\author{
Murat Genç and Ömer Özbilen
}
