% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals-liureg.R
\name{residuals.liureg}
\alias{residuals.liureg}
\title{Liu Regression Residuals}
\usage{
\method{residuals}{liureg}(object, ...)
}
\arguments{
\item{object}{An object of class \code{liureg}.}

\item{...}{Not used in this implementation.}
}
\value{
The returned object is a vector or matrix whose columns
are Liu residuals for each \code{lambda}.
}
\description{
Liu Regression Residuals
}
\examples{
Hitters <- na.omit(Hitters)
X <- model.matrix(Salary ~ ., Hitters)[, -1]
y <- Hitters$Salary
lam <- seq(0, 1, 0.01)
liu.mod <- liureg(X, y, lam)
residuals(liu.mod)
}
\seealso{
\code{\link[=liureg]{liureg()}}, \code{\link[=pressliu]{pressliu()}}, \code{\link[=residuals]{residuals()}}
}
\author{
Murat Genç
}
