% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_ale.R
\name{explain_ale}
\alias{explain_ale}
\title{Compute Accumulated Local Effects (ALE) for a fastml model}
\usage{
explain_ale(object, feature, data = c("train", "test"), ...)
}
\arguments{
\item{object}{A `fastml` object.}

\item{feature}{Character string specifying the feature name.}

\item{data}{Character string specifying which data to use: \code{"train"} (default) or \code{"test"}.}

\item{...}{Additional arguments passed to `iml::FeatureEffect`.}
}
\value{
An `iml` object containing ALE results.
}
\description{
Uses the `iml` package to calculate ALE for the specified feature.
}
\examples{
\dontrun{
data(iris)
iris <- iris[iris$Species != "setosa", ]
iris$Species <- factor(iris$Species)
model <- fastml(data = iris, label = "Species")
explain_ale(model, feature = "Sepal.Length")
}
}
