% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning_config.R
\name{get_tuning_complexity}
\alias{get_tuning_complexity}
\title{Tuning Complexity Presets}
\usage{
get_tuning_complexity(
  complexity = c("balanced", "quick", "thorough", "exhaustive")
)
}
\arguments{
\item{complexity}{Character string specifying the tuning complexity level.
One of:
\describe{
  \item{\code{"quick"}}{Minimal tuning for fast iteration. 2-3 levels per
    parameter, narrow ranges. Best for: initial exploration, prototyping,
    small datasets, time-constrained scenarios. Typical grid size: 4-27 points.}
  \item{\code{"balanced"}}{Moderate tuning balancing speed and thoroughness.
    3-4 levels per parameter, standard ranges. Best for: most production use
    cases, medium datasets. Typical grid size: 27-256 points. This is the default.
    }
  \item{\code{"thorough"}}{Comprehensive tuning for maximum model quality.
    4-5 levels per parameter, wide ranges. Best for: final model selection,
    publications, competitions, when compute time is not a constraint.
    Typical grid size: 256-3125 points.}
  \item{\code{"exhaustive"}}{Maximum coverage tuning. 5-7 levels per parameter,
    very wide ranges. Best for: research, benchmarking, when you need to be
    certain you've found the best hyperparameters. Warning: Can be very slow.
    Typical grid size: 1000-10000+ points. Consider using Bayesian tuning instead.}
}}
}
\value{
A list with components:
  \describe{
    \item{grid_levels}{Integer number of levels per parameter for grid search.}
    \item{bayes_iterations}{Integer number of iterations for Bayesian tuning.}
    \item{description}{Human-readable description of the complexity level.}
    \item{speed_estimate}{Relative speed estimate (1 = baseline).}
    \item{robustness_estimate}{Relative robustness estimate (1-5 scale).}
  }
}
\description{
Returns the configuration for a given tuning complexity level, including
grid levels, parameter ranges, and expected computational characteristics.
}
\details{
## Speed-Robustness Trade-offs

Hyperparameter tuning involves a fundamental trade-off between computational
cost and the likelihood of finding optimal hyperparameters:

\tabular{lllll}{
  \strong{Level} \tab \strong{Grid Size} \tab \strong{Time} \tab \strong{Robustness} \tab \strong{Use Case} \cr
  quick \tab 4-27 \tab ~1x \tab Low \tab Prototyping, debugging \cr
  balanced \tab 27-256 \tab ~10x \tab Medium \tab Most production use \cr
  thorough \tab 256-3125 \tab ~100x \tab High \tab Final models, papers \cr
  exhaustive \tab 1000-10000+ \tab ~1000x \tab Very High \tab Research, competitions \cr
}

### Recommendations:

1. **Start with "quick"** during development to iterate fast
2. **Use "balanced"** for most production pipelines
3. **Switch to "thorough"** for final model selection
4. **Consider Bayesian tuning** (`tuning_strategy = "bayes"`) for high-dimensional
   parameter spaces instead of exhaustive grid search
5. **Use adaptive/racing** (`adaptive = TRUE`) to early-stop poor configurations

### Computational Scaling:

Grid search scales as O(L^P * F * N) where:
- L = number of levels per parameter
- P = number of parameters being tuned
- F = number of cross-validation folds
- N = dataset size

For a model with 5 tunable parameters and 10-fold CV:
- quick (L=2): 2^5 * 10 = 320 model fits
- balanced (L=3): 3^5 * 10 = 2,430 model fits
- thorough (L=5): 5^5 * 10 = 31,250 model fits
}
\examples{
# Get configuration for balanced tuning
config <- get_tuning_complexity("balanced")
print(config$grid_levels)  # 3

# See all available presets
print_tuning_presets()

}
