% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fauna_by_vernacular.R
\name{fauna_by_vernacular}
\alias{fauna_by_vernacular}
\title{Search for taxa using vernacular names}
\usage{
fauna_by_vernacular(data, names, exact = FALSE)
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_faunabr}} function or generated with the function
\code{\link{select_fauna}}.}

\item{names}{(character) vernacular name ("Nome comum") of the species to be
searched}

\item{exact}{(logic) if TRUE, the function will search only for exact
matches. For example, if names = "veado-mateiro" and exact = TRUE, the function
will return only the species popularly known as "veado-mateiro". On the other
hand, if names = "veado-mateiro" and exact = FALSE, the function will return
other results as "Veado-mateiro-pequeno". Default = FALSE}
}
\value{
a data.frame with the species with vernacular names that match the
input names
}
\description{
Search for taxa using vernacular names
}
\examples{
data("fauna_data") #Load Fauna do Brasil data
#Search for species whose vernacular name is 'veado-mateiro'
veado_exact <- fauna_by_vernacular(data = fauna_data,
                                   names = "veado-mateiro",
                                   exact = TRUE)
veado_exact
#Search for species whose vernacular name is 'veado_mateiro', allowing non-exact
#matches
veado_not_exact <- fauna_by_vernacular(data = fauna_data,
                                       names = "veado-mateiro",
                                      exact = FALSE)

}
