% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fb_copy_campaign.R
\name{fbad_copy_campaign}
\alias{fbad_copy_campaign}
\title{Create a copy of a campaign. You can copy a maximum of 3 entities between campaign, ad sets and ads.}
\usage{
fbad_copy_campaign(
  fbacc,
  campaign_id,
  start_time = NULL,
  end_time = NULL,
  deep_copy = NULL,
  status_option = NULL,
  rename_strategy = NULL,
  rename_prefix = NULL,
  rename_suffix = NULL,
  ...
)
}
\arguments{
\item{fbacc}{(optional) \code{FB_Ad_account} object, which defaults to the last returned object of \code{\link{fbad_init}}.}

\item{campaign_id}{(numeric string or integer) Single ID of a campaign to make parent of the copy. Ignore if you want to keep the copy under the original campaign parent}

\item{start_time}{(datetime) The start time of the ad set. If not set, the copied adset will inherit the start time from the original set}

\item{end_time}{(datetime) The end time of the ad set}

\item{deep_copy}{(boolean) Default value: false. Whether to copy all the child ads}

\item{status_option}{(string) enum {ACTIVE, PAUSED, INHERITED_FROM_SOURCE}}

\item{rename_strategy}{(string) enum {DEEP_RENAME, ONLY_TOP_LEVEL_RENAME, NO_RENAME}}

\item{rename_prefix}{(string) a prefix to copy names. Defaults to null if not provided}

\item{rename_suffix}{(string) a suffix to copy names. Defaults to null if not provided}

\item{...}{further arguments passed to the API endpoint}
}
\description{
Create a copy of a campaign. You can copy a maximum of 3 entities between campaign, ad sets and ads.
}
\references{
\url{https://developers.facebook.com/docs/marketing-api/reference/ad-campaign-group/copies/}
}
