% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fb_creative.R
\name{fbad_read_creative}
\alias{fbad_read_creative}
\title{Read ad creative}
\usage{
fbad_read_creative(
  fbacc,
  id,
  by = c("account", "creative", "ad"),
  fields = c("id", "name", "body", "title", "run_status", "actor_id",
    "call_to_action_type", "follow_redirect", "image_crops", "image_file", "image_hash",
    "image_url", "thumbnail_url", "link_url", "url_tags", "object_id", "object_story_id",
    "object_story_spec", "object_type", "object_url")
)
}
\arguments{
\item{fbacc}{(optional) \code{FB_Ad_account} object, which defaults to the last returned object of \code{\link{fbad_init}}.}

\item{id}{Ad Creative or Ad Set id}

\item{by}{get all Ad Creatives for the account, for a given Ad or a single Creative}

\item{fields}{character vector of fields to get from the API}
}
\value{
list to be post-processed
}
\description{
Read ad creative
}
\examples{
\dontrun{
## get all creatives for the current account
fbad_read_creative(fbacc)
}
}
\references{
\url{https://developers.facebook.com/docs/marketing-api/reference/ad-creative#Reading}
}
