% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_expression_evaluation.R
\name{gene_eval}
\alias{gene_eval}
\title{Function to estimate the expression levels of gene sets}
\usage{
gene_eval(gene_sets, genes, presences)
}
\arguments{
\item{gene_sets}{A list of gene set strings: names of genes punctuated with \code{&}, \code{|} and brackets.}

\item{genes}{A list of gene names}

\item{presences}{A list of gene presences, the same length as \code{genes}}
}
\value{
a vector the same length as \code{gene_sets}, with the the calculated combined gene expression levels.

This function evaluates the gene sets in the context of the gene presences. 
It can take booleans, or numbers, in which case it associates \code{&} with finding the minimum, and \code{|} with finding the maximum.
}
\description{
Function to estimate the expression levels of gene sets
}
\section{Warning}{

This function uses \code{\link{eval}} to evaluate gene expression sets. 
This gives flexibility, but means that malicious code in the \code{gene_sets} argument could get evaluated.
\code{gene_sets} is evaluated in a restricted environment, but there might be a way around this, so you might want to check for anything suspicious in this argument manually.
For more information, read the code.
}

\seealso{
gene_associate
}
