% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbglm.R
\name{fbglm}
\alias{fbglm}
\title{Fractional binomial regression model}
\usage{
fbglm(y, x)
}
\arguments{
\item{y}{A response vector.}

\item{x}{A data frame with covariates.}
}
\value{
A list of log-likelihood, estimated coefficients, and maximum likelihood estimation results.
}
\description{
Fit a fractional binomial regression model via maximum likelihood.
}
\details{
Fractional binomial distribution can be considered as zero-inflated, over-dispersed binomial model, and it has three parameters
\eqn{(p,H,c)} in addition to the number of trials \eqn{n}.
We use a specific parametrization such that  \eqn{p,H,c \in (0,1)}, and
regress these parameters with logit link on the covariates, while letting \eqn{n} as the maximum of the response \code{y}.
}
\examples{
library(agridat)
library(bbmle)
sample<-sample(270, 30)
my_y<-ridout.appleshoots$roots[sample]
my_x<-data.frame(pho=ridout.appleshoots$pho[sample])
fbglm(y=my_y, x=my_x  )

}
\references{
Breece, C. and Lee, J. (2024) Fractional binomial regression model for count data with excess zeros.\url{https://arxiv.org/html/2410.08488v1}
}
