% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{ft_map_func}
\alias{ft_map_func}
\title{Map Factor Levels Using a Function}
\usage{
ft_map_func(factor_vec, map_func)
}
\arguments{
\item{factor_vec}{A factor vector to map.}

\item{map_func}{A function that takes a character vector of levels and returns a character vector of new levels.}
}
\value{
A factor vector with levels mapped according to the function.
}
\description{
Transforms factor levels by applying a function that can include complex logic.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple', 'banana', 'cherry'))

# Map levels to uppercase if they start with 'a'
ft_map_func(factor_vec, function(x) {
  ifelse(grepl('^a', x), toupper(x), x)
})
}
\author{
Kai Guo
}
