% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_comp.R
\name{ft_pairs}
\alias{ft_pairs}
\title{Generate Pairwise Comparisons Between Elements in factor}
\usage{
ft_pairs(
  factor_vec,
  ref = NULL,
  symmetric = TRUE,
  include_na = FALSE,
  include_self = FALSE,
  filter_fn = NULL,
  pre_fn = trimws,
  sort_by = "none",
  output_format = "data.frame"
)
}
\arguments{
\item{factor_vec}{A vector containing the factor_vec to compare. Can be of any type (character, numeric, factor, etc.).}

\item{ref}{Optional. A vector containing the reference factor_vec. If NULL (default), comparisons are made within the \code{factor_vec} vector.}

\item{symmetric}{Logical. If \code{TRUE} (default), unique unordered pairs are returned. If \code{FALSE}, all ordered pairs are returned.}

\item{include_na}{Logical. If \code{FALSE} (default), \code{NA} values are excluded from comparisons. If \code{TRUE}, \code{NA} values are included.}

\item{include_self}{Logical. If \code{FALSE} (default), pairs where \code{Var1 == Var2} are excluded. If \code{TRUE}, they are included.}

\item{filter_fn}{Optional. A custom function to filter the pairs. Should accept a data frame and return a logical vector.}

\item{pre_fn}{Optional. A function to preprocess the factor_vec before comparison (e.g., \code{tolower}, \code{trimws}). Default is \code{trimws}.}

\item{sort_by}{Character string specifying how to sort the output. Options are \code{"Var1"}, \code{"Var2"}, \code{"both"}, or \code{"none"} (default).}

\item{output_format}{Character string specifying the output format. Options are \code{"data.frame"} (default), \code{"list"}, or \code{"matrix"}.}
}
\value{
A data frame, list, matrix, or tibble containing pairwise comparisons between factor_vec.
}
\description{
Creates all unique pairwise combinations between factor_vec of a vector, with options for references, symmetry, NA handling, custom filtering, and output formats. Automatically handles factors by converting them to vectors and removes extra spaces from factor_vec before processing.
}
\examples{
# Example vector with extra spaces and mixed case
vec <- c(' A', 'b ', ' C ', 'D')

# Generate pairwise comparisons within vec
ft_pairs(vec)

# Use a custom preprocessing function to convert factor_vec to lower case
ft_pairs(vec, pre_fn = function(x) tolower(trimws(x)))
ft_pairs(vec, ref = c("A","C"))
}
