% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_fct.R
\name{ft_substr_freq}
\alias{ft_substr_freq}
\title{Reorder Factor Levels Based on Substring Frequency}
\usage{
ft_substr_freq(
  factor_vec,
  start_pos = NULL,
  end_pos = NULL,
  case = FALSE,
  decreasing = TRUE,
  inplace = TRUE
)
}
\arguments{
\item{factor_vec}{A factor vector whose levels are to be reordered.}

\item{start_pos}{Positive integer. The starting position of the substring. If \code{NULL}, starts from the beginning.}

\item{end_pos}{Positive integer. The ending position of the substring. If \code{NULL}, goes to the end of the string.}

\item{case}{Logical. Should the substring comparison be case-sensitive? Default is \code{FALSE}.}

\item{decreasing}{Logical. Should the ordering be decreasing by frequency? Default is \code{TRUE}.}

\item{inplace}{Logical. If \code{TRUE}, returns a new factor vector with elements reordered to align with the new levels' order. If \code{FALSE}, returns a new factor vector with only the levels' order adjusted, leaving the data vector's elements' order unchanged. Defaults to \code{FALSE}.}
}
\value{
A factor vector with levels reordered based on the frequency of substrings.
}
\description{
Reorders the levels of a factor vector based on the frequency of substrings extracted from the data.
}
\examples{
# Example factor vector with multi-byte characters
factor_vec <- factor(c('apple', 'banana', 'apricot', 'cherry', 'banana', 'banana', 'date'))
# Reorder from position 2 to end
ft_substr_freq(factor_vec, start_pos = 2)
factor_vec <- factor(c('apple', 'banana', 'apricot', 'cherry', 'banana', 'banana', 'date'))
ft_substr_freq(factor_vec, start_pos = 2, end_pos=3)
}
\author{
Kai Guo
}
