% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_flag-time_period.R
\name{create_time_period_feature_flag}
\alias{create_time_period_feature_flag}
\title{Creates an instance of a time period feature flag.}
\usage{
create_time_period_feature_flag(from = NULL, to = NULL)
}
\arguments{
\item{from}{date-time from which the feature flag should be enabled
set as null if you want a one sided boundary.}

\item{to}{date-time to which the feature flag should be enabled
set as null if you want a one sided boundary}
}
\description{
Creates an instance of a time period feature flag.
}
\details{
Boundaries are set as inclusive
}
\examples{
{
  two_sided_flag <- create_time_period_feature_flag(
    from = ISOdatetime(2020, 10, 10, 0, 0, 0, tz = "UTC"),
    to = ISOdatetime(2020, 11, 10, 0, 0, 0, tz = "UTC")
  )

  left_sided_flag <- create_time_period_feature_flag(
    from = ISOdatetime(2020, 10, 10, 0, 0, 0, tz = "UTC")
  )

  right_sided_flag <- create_time_period_feature_flag(
    to = ISOdatetime(2020, 10, 10, 0, 0, 0, tz = "UTC")
  )
}
}
