% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fee_negbin.R
\name{fee_negbin}
\alias{fee_negbin}
\title{First-Exposure Effect for One-Inflated Zero-Truncated Negative Binomial Model}
\usage{
fee_negbin(b, g, a, X, Z)
}
\arguments{
\item{b}{A numeric vector of estimated coefficients for the rate.}

\item{g}{A numeric vector of estimated coefficients for inflation.}

\item{a}{A dispersion parameter from the negative binomial model.}

\item{X}{A numeric matrix of covariates for the rate.}

\item{Z}{A numeric matrix of covariates for inflation.}
}
\value{
A numeric vector of first-exposure effect(s).
}
\description{
Computes the first-exposure effect (FEE) for a model estimated using the
one-inflated zero-truncated negative binomial distribution. The FEE represents
the change in expected counts associated with the first exposure to treatment,
relative to the counterfactual zero-truncated negative binomial model. This
function is used internally by \code{\link{fee}} at given covariate values.
}
\seealso{
\code{\link{fee}}, \code{\link{fee_pois}}
}
\keyword{internal}
