% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_nhp.R
\name{filter_nhp}
\alias{filter_nhp}
\title{Format non-human primate search terms for use in databases}
\usage{
filter_nhp(
  source = "PubMed",
  taxa = "nonhuman_primates",
  omit = NULL,
  simplify = TRUE
)
}
\arguments{
\item{source}{A string indicating which bibliographic source search terms
should be formatted for. Current options are "PubMed" (default), "PsycInfo"
or "WebOfScience".}

\item{taxa}{A character vector of primate taxa. If \code{taxa =
"nonhuman_primates"} (default), function will return search terms for all
non-human primates. Use \code{\link{get_nhp_taxa}} to print a list of valid
taxa.}

\item{omit}{An optional character vector of primate taxonomic groups that
occur within taxa to omit from the search terms. This is useful for example
when you need search terms for all species of one family except one genus.}

\item{simplify}{Logical. Should printed output be simplified?}
}
\value{
\code{NULL} or a string of search terms that are associated with the
  specified taxa, formatted for use in the specified bibliographic source.
}
\description{
Function will return search terms for all taxa below the specified taxonomic
level. Search terms for humans are always omitted, even if they are part of
that taxonomic group.
}
\details{
If \code{simplify = TRUE} (default), then function will print search
  terms to the console that can be directly copy-pasted into the relevant
  bibliographic source as is. However, the object returned is \code{NULL}. If
  \code{simplify = FALSE}, then function returns a character vector of length
  == 1. This may be useful if the user wants to assign the output to an r
  object for further manipulation.
}
\examples{
filter_nhp(source = "PsycInfo", taxa = "papio")
filter_nhp(source = "PsycInfo", taxa = "hominidae")
filter_nhp(source = "PubMed", taxa = "cercopithecidae", omit = c("papio", "macaca"))
filter_nhp(source = "PubMed", taxa = "platyrrhini", omit = "aotus")
}
