% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{fill_safe_value}
\alias{fill_safe_value}
\title{Fill safe value \emph{(singular)}}
\arguments{
\item{x}{A score class object (e.g., \code{score_cor_pearson}).}

\item{return_results}{A logical value indicating whether to return results.}
}
\value{
A tibble of score results.
}
\description{
Fills in safe value for missing score, with an option to apply transformation.
This is a \emph{singular} scoring method. See \code{\link[=fill_safe_values]{fill_safe_values()}} for \emph{plural} scoring method.
}
\details{
If \code{transform = TRUE}, by default, all score objects use the identity transformation, except the
correlation score object, which uses the absolute transformation.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(dplyr)

ames_subset <- modeldata::ames |>
  dplyr::select(
    Sale_Price,
    MS_SubClass,
    MS_Zoning,
    Lot_Frontage,
    Lot_Area,
    Street
  )
ames_subset <- ames_subset |>
  dplyr::mutate(Sale_Price = log10(Sale_Price))

ames_aov_pval_res <-
  score_aov_pval |>
  fit(Sale_Price ~ ., data = ames_subset)
ames_aov_pval_res@results

# Fill safe value
ames_aov_pval_res |> fill_safe_value(return_results = TRUE)

# Fill safe value, option to transform
ames_aov_pval_res |> fill_safe_value(return_results = TRUE, transform = TRUE)
\dontshow{\}) # examplesIf}
}
