% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{fill_safe_values}
\alias{fill_safe_values}
\title{Fill safe values \emph{(plural)}}
\arguments{
\item{x}{A list.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A tibble of scores results.
}
\description{
Wraps \code{\link[=bind_scores]{bind_scores()}}, and fills in safe values for missing scores, with an option to apply transformation.
This is a \emph{plural} scoring method. See \code{\link[=fill_safe_value]{fill_safe_value()}} for \emph{singular} scoring method.
}
\details{
If \code{transform = TRUE}, by default, all score objects use the identity transformation, except the
correlation score object, which uses the absolute transformation.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(dplyr)

ames_subset <- modeldata::ames |>
  dplyr::select(
    Sale_Price,
    MS_SubClass,
    MS_Zoning,
    Lot_Frontage,
    Lot_Area,
    Street
  )
ames_subset <- ames_subset |>
  dplyr::mutate(Sale_Price = log10(Sale_Price))

# ANOVA p-value
ames_aov_pval_res <-
  score_aov_pval |>
  fit(Sale_Price ~ ., data = ames_subset)
ames_aov_pval_res@results

# Pearson correlation
ames_cor_pearson_res <-
  score_cor_pearson |>
  fit(Sale_Price ~ ., data = ames_subset)
ames_cor_pearson_res@results

# Forest importance
set.seed(42)
ames_imp_rf_reg_res <-
  score_imp_rf |>
  fit(Sale_Price ~ ., data = ames_subset)
ames_imp_rf_reg_res@results

# Information gain
ames_info_gain_reg_res <-
  score_info_gain |>
  fit(Sale_Price ~ ., data = ames_subset)
ames_info_gain_reg_res@results

# Create a list
class_score_list <- list(
  ames_aov_pval_res,
  ames_cor_pearson_res,
  ames_imp_rf_reg_res,
  ames_info_gain_reg_res
)

# Fill safe values
class_score_list |> fill_safe_values()

# Fill safe value, option to transform
class_score_list |> fill_safe_values(transform = TRUE)
\dontshow{\}) # examplesIf}
}
