% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findPackage.R
\name{findPackage}
\alias{findPackage}
\title{Find 'CRAN' Package by topic}
\usage{
findPackage(
  topicString = "",
  fromDate = "2008-09-01",
  toDate = Sys.Date(),
  sortOrder = "A"
)
}
\arguments{
\item{topicString}{The topic as a character string or as a 
regular expression}

\item{fromDate}{Format: YYYY-MM-DD. The search in CRAN will be restricted 
to packages published on or after this date, default is from the earliest 
available date, i.e. September 2008}

\item{toDate}{Format: YYYY-MM-DD. The search in CRAN will be restricted 
to packages published on or before this date, default is till the 
current date}

\item{sortOrder}{The matching data is sorted by default (A) with the 
earlier published packages preceding the later ones. For descending sort,
more recent earlier, use "D"}
}
\value{
A data frame with the package name, the date of publication,
title of the package and its description
}
\description{
Finds CRAN packages by the topic requested. The topic can be
 given as a character string or as a regular expression, and will help users
 to locate packages matching their specified requirement.
}
\examples{
ahp <- findPackage("(Analytic Hierarchy Process)|(AHP)");

AHP_or_DEA <- 
findPackage(
"(Analytic Hierarchy Process)|(AHP)|(Data Envelopment Analysis)|(DEA)");

fa <- findPackage("Factor Analysis")
}
