% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_svi_x.R
\name{find_svi_x}
\alias{find_svi_x}
\title{Retrieve census data and calculate SVI for a customized geographic level}
\usage{
find_svi_x(
  year,
  geography,
  state = NULL,
  county = NULL,
  key = NULL,
  geometry = FALSE,
  xwalk
)
}
\arguments{
\item{year}{A year of interest (available 2012-2022).}

\item{geography}{The Census geography level of interest (e.g."county",
"zcta", "tract").}

\item{state}{(Optional) Specify the state of interest. Default \code{state = NULL}
or \code{state = 'US'} return nation-level data.}

\item{county}{(Optional) Specify the county of interest, must be combined
with a value supplied to "state".}

\item{key}{Your Census API key. Obtain one at
\url{https://api.census.gov/data/key_signup.html}. To set up, use
\code{tidycensus::census_api_key("YOUR KEY GOES HERE")}, or include it as an
argument.}

\item{geometry}{Default as \code{FALSE} for retrieving census data without spatial
information. Set as \code{TRUE} for retrieving census data with an additional
\code{geometry} column containing simple feature geometry.}

\item{xwalk}{A crosswalk (relationship table) between the Census geographic
level and the customized geographic level of interest. A crosswalk between
US counties and commuting zones \code{cty_cz_2020_xwalk} is included as an
example, and please set the column names of the crosswalk as follows:
\describe{
\item{GEOID}{Identifiers for the Census geographic level. Must contain values from \code{GEOID} column in \code{data}, and be in a compatible data type (character).}
\item{GEOID2}{Identifiers (characters or numeric values) for the customized geographic level that is larger geographic than the Census geographic level. The Census geographic level should be nested in the customized geographic level.}
\item{NAME}{An optional column of the names or description of the customized geographic level.}
}}
}
\value{
A tibble of SVI with rows representing the customized geographic
units (with a column name of \code{GEOID}), and columns indicating variable
names (first two columns containing geographic information). For detailed
description of the variable names (column names), please refer to
CDC/ATSDR
documentation (https://www.atsdr.cdc.gov/placeandhealth/svi/data_documentation_download.html).
}
\description{
\code{find_svi_x()} is like a wrapper for
\code{\link[=get_census_data]{get_census_data()}} and \code{\link[=get_svi_x]{get_svi_x()}} that retrieves
census data and produces SVI for a customized geographic level consisted of
a Census geography. The census data is retrieved at the Census geographic
level, and estimate counts are summed across the customized geographic
level to calculate SVI. Note that a Census API key is required for this
function to work, which can be obtained at
\url{https://api.census.gov/data/key_signup.html} and set up using
\code{\link[tidycensus:census_api_key]{tidycensus::census_api_key()}}.
}
\examples{
\dontshow{if (Sys.getenv("CENSUS_API_KEY") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Census API key required

  find_svi_x(
    year = 2020,
    geography = "county",
    xwalk = cty_cz_2020_xwalk
    )
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=find_svi]{find_svi()}} for retrieving census data and calculating SVI for
multiple year-state pairs at a Census geographic level. \code{\link[=get_census_data]{get_census_data()}}
(with \code{exp = TRUE}) and \code{\link[=get_svi_x]{get_svi_x()}} for separate functions for data
retrieval and SVI calculation at a customized geographic level.
}
