% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_api_access.R
\name{check_api_access}
\alias{check_api_access}
\title{Check Access to the Finna API}
\usage{
check_api_access()
}
\value{
A logical value:
\itemize{
\item \code{TRUE}: The API is accessible.
\item \code{FALSE}: The API is not accessible.
}
}
\description{
This function tests whether R can successfully connect to the Finna API by downloading
the OpenAPI specification from \verb{https://api.finna.fi/api/v1/?openapi}. It returns
a logical value indicating the accessibility of the API.
}
\examples{
\dontrun{
  # Check if the API is accessible
  access <- check_api_access()
  if (access) {
    message("Finna API is accessible")
  } else {
    message("Finna API is not accessible")
  }
}
}
