% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{esg_emission_factor_elec_production_FI_RTD}
\alias{esg_emission_factor_elec_production_FI_RTD}
\title{Emission factor of electricity production in Finland - real time data}
\usage{
esg_emission_factor_elec_production_FI_RTD(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 3 min and unit type gCO2/kWh.
}
\description{
Near in real time calculated carbon dioxide emission estimate of electricity production in Finland. The emissions are estimated by summing each product of different electricity production type and their emission factor together, and by dividing the sum by Finland's total electricity production. The data is updated every 3 minutes.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- esg_emission_factor_elec_production_FI_RTD(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/266
}
