% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{get_page_data}
\alias{get_page_data}
\title{Returns one page of JSON data}
\usage{
get_page_data(
  page_num,
  page_size,
  api_number,
  start_time_utc,
  end_time_utc,
  api_key
)
}
\arguments{
\item{page_num}{Integer which page to retrieve from API.}

\item{page_size}{Integer how many observations per page are collected.}

\item{api_number}{Integer related to the Fingrid Open Data API}

\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{api_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en.}
}
\value{
A data frame object that contains a single page from API.
}
\description{
This private function helps with JSON API pagination by
returning a single page of observations at once.
}
