% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{powersys_production_surplus}
\alias{powersys_production_surplus}
\title{Electricity production, surplus/deficit - real time data}
\usage{
powersys_production_surplus(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 3 min and unit type MW.
}
\description{
Finland's energy production surplus/deficit. Information is based on the real time measurements in Fingrid's power control system.Power deficit/surplus represents the balance between power production and consumption in Finland, taking into account imports and exports. Power deficit/surplus is calculated as the difference between the measured net import/export and the confirmed net exchange program between Finland and the other Nordic countries.Sign convention: production deficit -, surplus +The data is updated every 3 minutes.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- powersys_production_surplus(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/198
}
