% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_concept_network.R
\name{fst_cn_edges}
\alias{fst_cn_edges}
\title{Concept Network - Get TextRank edges}
\usage{
fst_cn_edges(
  data,
  concepts,
  threshold = NULL,
  norm = "number_words",
  pos_filter = NULL
)
}
\arguments{
\item{data}{A dataframe of text in CoNLL-U format, with optional additional
columns.}

\item{concepts}{List of terms to search for, separated by commas.}

\item{threshold}{A minimum number of occurrences threshold for 'edge' between
searched term and other word, default is `NULL`. Note, the threshold is
applied before normalisation.}

\item{norm}{The method for normalising the data. Valid settings are
`"number_words"` (the number of words in the responses), `"number_resp"`
(the number of responses), or `NULL` (raw count returned, default, also used
when weights are applied).}

\item{pos_filter}{List of UPOS tags for inclusion, default is `NULL` to
include all UPOS tags.}
}
\value{
Dataframe of co-occurrences between two connected words.
}
\description{
This function takes a string of terms (separated by commas) or a single term
and, using `fst_cn_search()` find words connected to these searched terms.
Then, a dataframe is returned of 'edges' between two words which are
connected together in an frequently-occurring n-gram containing a concept
term.
}
\examples{
con <- "kiusata, lyöminen"
fst_cn_edges(fst_child, con, pos_filter = c("NOUN", "VERB", "ADJ", "ADV"))
fst_cn_edges(fst_child, con, pos_filter = 'VERB, NOUN')
fst_cn_edges(fst_child, "lyöminen", threshold = 2, norm = "number_resp")
}
