% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fireproof.R
\name{Fireproof}
\alias{Fireproof}
\title{A plugin that handles authentication and/or authorization}
\description{
This plugin orchestrates all guards for your fiery app. It is a
special \link[routr:Route-class]{Route} that manages all the different guards you have
defined as well as testing all the endpoints that have auth requirements.
}
\details{
A guard is an object deriving from the \link{Guard} class which is usually created
with one of the \verb{guard_*()} constructors. You can provide it with a name as
you register it and can thus have multiple instances of the same scheme (e.g.
two \code{guard_basic()} with different user lists)

An auth handler is a handler that consists of a method, path, and
flow. The flow is a logical expression of the various guards the request
must pass to get access to that endpoint. For example, if you have two
guards named \code{auth1} and \code{auth2}, a flow could be \code{auth1 || auth2} to allow
a request if it passes either of the guards. Given an additional guard,
\code{auth3}, it could also be something like \code{auth1 || (auth2 && auth3)}. The
flow is given as a bare expression, not as a string. In addition to the three
required arguments you can also supply a character vector of scopes that are
required to have access to the endpoint. If your guard has scope support
then the request will be tested against these to see if the (otherwise valid)
user has permission to the resource.
}
\examples{
# Create a fireproof plugin
fp <- Fireproof$new()

# Create some authentication schemes and add them
basic <- guard_basic(
  validate = function(user, password) {
    user == "thomas" && password == "pedersen"
  },
  user_info = function(user) {
    new_user_info(
      name_given = "Thomas",
      name_middle = "Lin",
      name_family = "Pedersen"
    )
  }
)
fp$add_guard(basic, "basic_auth")

key <- guard_key(
  key_name = "my-key-location",
  validate = "SHHH!!DONT_TELL_ANYONE"
)
fp$add_guard(key, "key_auth")

google <- guard_google(
  redirect_url = "https://example.com/auth",
  client_id = "MY_APP_ID",
  client_secret = "SUCHASECRET",
)
fp$add_guard(google, "google_auth")

# Add authentication to different paths
fp$add_auth("get", "/require_basic", basic_auth)

fp$add_auth("get", "/require_basic_and_key", basic_auth && key_auth)

fp$add_auth(
  "get",
  "/require_google_or_the_others",
  google_auth || (basic_auth && key_auth)
)

\dontshow{if (requireNamespace("fiery", quietly = TRUE) && requireNamespace("firesale", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Add plugin to fiery app
app <- fiery::Fire$new()

# First add the firesale plugin as it is required
fs <- firesale::FireSale$new(storr::driver_environment(new.env()))
app$attach(fs)

# Then add the fireproof plugin
app$attach(fp)
\dontshow{\}) # examplesIf}
}
\section{Super class}{
\code{\link[routr:Route]{routr::Route}} -> \code{Fireproof}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{The name of the plugin: \code{"fireproof"}}

\item{\code{require}}{Required plugins for Fireproof}

\item{\code{guards}}{The name of all the guards currently added to the plugin}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Fireproof-print}{\code{Fireproof$print()}}
\item \href{#method-Fireproof-add_auth}{\code{Fireproof$add_auth()}}
\item \href{#method-Fireproof-add_guard}{\code{Fireproof$add_guard()}}
\item \href{#method-Fireproof-add_handler}{\code{Fireproof$add_handler()}}
\item \href{#method-Fireproof-flow_to_openapi}{\code{Fireproof$flow_to_openapi()}}
\item \href{#method-Fireproof-on_attach}{\code{Fireproof$on_attach()}}
\item \href{#method-Fireproof-clone}{\code{Fireproof$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="routr" data-topic="Route" data-id="dispatch"><a href='../../routr/html/Route.html#method-Route-dispatch'><code>routr::Route$dispatch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="routr" data-topic="Route" data-id="get_handler"><a href='../../routr/html/Route.html#method-Route-get_handler'><code>routr::Route$get_handler()</code></a></span></li>
<li><span class="pkg-link" data-pkg="routr" data-topic="Route" data-id="initialize"><a href='../../routr/html/Route.html#method-Route-initialize'><code>routr::Route$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="routr" data-topic="Route" data-id="merge_route"><a href='../../routr/html/Route.html#method-Route-merge_route'><code>routr::Route$merge_route()</code></a></span></li>
<li><span class="pkg-link" data-pkg="routr" data-topic="Route" data-id="remap_handlers"><a href='../../routr/html/Route.html#method-Route-remap_handlers'><code>routr::Route$remap_handlers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="routr" data-topic="Route" data-id="remove_handler"><a href='../../routr/html/Route.html#method-Route-remove_handler'><code>routr::Route$remove_handler()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fireproof-print"></a>}}
\if{latex}{\out{\hypertarget{method-Fireproof-print}{}}}
\subsection{Method \code{print()}}{
Print method for the class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fireproof$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fireproof-add_auth"></a>}}
\if{latex}{\out{\hypertarget{method-Fireproof-add_auth}{}}}
\subsection{Method \code{add_auth()}}{
Add a new authentication handler. It invisibly returns the
parsed flow so it can be used for generating OpenAPI specs with.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fireproof$add_auth(method, path, flow, scope = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{The http method to match the handler to}

\item{\code{path}}{The URL path to match to}

\item{\code{flow}}{The authentication flow the request must pass to be valid.
See \emph{Details}. If \code{NULL} then authentication is turned off for the
endpoint.}

\item{\code{scope}}{An optional character vector of scopes that the request must
have permission for to access the resource}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fireproof-add_guard"></a>}}
\if{latex}{\out{\hypertarget{method-Fireproof-add_guard}{}}}
\subsection{Method \code{add_guard()}}{
Add a guard to the plugin
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fireproof$add_guard(guard, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{guard}}{Either a \link{Guard} object defining the guard (preferred) or a
function taking the standard route handler arguments (\code{request},
\code{response}, \code{keys}, and \code{...}) and returns \code{TRUE} if the request is valid
and \code{FALSE} if not.}

\item{\code{name}}{The name of the guard to be used when defining flow
for endpoint auth.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fireproof-add_handler"></a>}}
\if{latex}{\out{\hypertarget{method-Fireproof-add_handler}{}}}
\subsection{Method \code{add_handler()}}{
Defunct overwrite of the \code{add_handler()} method to prevent
this route to be used for anything other than auth. Will throw
an error if called.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fireproof$add_handler(method, path, handler, reject_missing_methods = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{ignored}

\item{\code{path}}{ignored}

\item{\code{handler}}{ignored}

\item{\code{reject_missing_methods}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fireproof-flow_to_openapi"></a>}}
\if{latex}{\out{\hypertarget{method-Fireproof-flow_to_openapi}{}}}
\subsection{Method \code{flow_to_openapi()}}{
Turns a parsed flow (as returned by \code{add_auth()})
into an OpenAPI Security Requirement compliant list. Not all flows can be
represented by the OpenAPI spec and the method will return \code{NULL} with a
warning if so. Scope is added to all schemes, even if not applicable, so
the final OpenAPI doc should be run through \code{\link[=prune_openapi]{prune_openapi()}} before
serving it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fireproof$flow_to_openapi(flow, scope)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{flow}}{A parsed flow as returned by \code{add_auth()}}

\item{\code{scope}}{A character vector of scopes required for this particular
flow}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fireproof-on_attach"></a>}}
\if{latex}{\out{\hypertarget{method-Fireproof-on_attach}{}}}
\subsection{Method \code{on_attach()}}{
Method for use by fiery when attached as a plugin. Should
not be called directly. This method looks for a header route stack in the
app and if it doesn't exist it creates one. It then attaches the plugin
as the first route to it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fireproof$on_attach(app, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app}}{The Fire object to attach the router to}

\item{\code{...}}{Ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fireproof-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Fireproof-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fireproof$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
