% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guard_oauth2.R
\name{GuardOAuth2}
\alias{GuardOAuth2}
\title{R6 class for the OAuth 2.0 Guard}
\description{
This class encapsulates the logic of the oauth 2.0 based authentication
scheme. See \code{\link[=guard_oauth2]{guard_oauth2()}} for more information
}
\examples{
# Example using GitHub endpoints (use `guard_github()` in real code)
github <- GuardOAuth2$new(
  token_url = "https://github.com/login/oauth/access_token",
  redirect_url = "https://example.com/auth",
  client_id = "MY_APP_ID",
  client_secret = "SUCHASECRET",
  auth_url = "https://github.com/login/oauth/authorize",
  grant_type = "authorization_code"
)

}
\section{Super class}{
\code{\link[fireproof:Guard]{fireproof::Guard}} -> \code{GuardOAuth2}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{open_api}}{An OpenID compliant security scheme description}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GuardOAuth2-new}{\code{GuardOAuth2$new()}}
\item \href{#method-GuardOAuth2-check_request}{\code{GuardOAuth2$check_request()}}
\item \href{#method-GuardOAuth2-reject_response}{\code{GuardOAuth2$reject_response()}}
\item \href{#method-GuardOAuth2-register_handler}{\code{GuardOAuth2$register_handler()}}
\item \href{#method-GuardOAuth2-refresh_token}{\code{GuardOAuth2$refresh_token()}}
\item \href{#method-GuardOAuth2-clone}{\code{GuardOAuth2$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fireproof" data-topic="Guard" data-id="forbid_user"><a href='../../fireproof/html/Guard.html#method-Guard-forbid_user'><code>fireproof::Guard$forbid_user()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardOAuth2-new"></a>}}
\if{latex}{\out{\hypertarget{method-GuardOAuth2-new}{}}}
\subsection{Method \code{new()}}{
Constructor for the class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardOAuth2$new(
  token_url,
  redirect_url,
  client_id,
  client_secret,
  auth_url = NULL,
  grant_type = c("authorization_code", "password"),
  oauth_scopes = NULL,
  validate = function(info) TRUE,
  redirect_path = get_path(redirect_url),
  on_auth = replay_request,
  user_info = NULL,
  service_params = list(),
  scopes_delim = " ",
  name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token_url}}{The URL to the authorization servers token endpoint}

\item{\code{redirect_url}}{The URL the authorization server should redirect to
following a successful authorization. Must be equivalent to one provided
when registering your application}

\item{\code{client_id}}{The ID issued by the authorization server when
registering your application}

\item{\code{client_secret}}{The secret issued by the authorization server when
registering your application. Do NOT store this in plain text}

\item{\code{auth_url}}{The URL to redirect the user to when requesting
authorization (only needed for \code{grant_type = "authorization_code"})}

\item{\code{grant_type}}{The type of authorization scheme to use, either
\code{"authorization_code"} or \code{"password"}}

\item{\code{oauth_scopes}}{Optional character vector of scopes to request the
user to grant you during authorization. These will \emph{not} influence the
scopes granted by the \code{validate} function and fireproof scoping. If named,
the names are taken as scopes and the elements as descriptions of the scopes,
e.g. given a scope, \code{read}, it can either be provided as \code{c("read")} or
\code{c(read = "Grant read access")}}

\item{\code{validate}}{Function to validate the user once logged in. It will be
called with a single argument \code{info}, which gets the information of the user
as provided by the \code{user_info} function. By default it returns \code{TRUE}
on everything meaning that anyone who can log in with the provider will
be accepted, but you can provide a different function to e.g. restrict
access to certain user names etc. If the function returns a
character vector it is considered to be authenticated and the return value
will be understood as scopes the user is granted.}

\item{\code{redirect_path}}{The path that should capture redirects after
successful authorization. By default this is derived from \code{redirect_url}
by removing the domain part of the url, but if for some reason this
doesn't yields the correct result for your server setup you can overwrite
it here.}

\item{\code{on_auth}}{A function which will handle the result of a successful
authorization. It will be called with four arguments: \code{request}, \code{response},
\code{session_state}, and \code{server}. The first contains the current request
being responded to, the second is the response being send back, the third
is a list recording the state of the original request which initiated the
authorization (containing \code{method}, \code{url}, \code{headers}, and \code{body} fields
with information from the original request). By default it will use
\link{replay_request} to internally replay the original request and send back
the response.}

\item{\code{user_info}}{A function to extract user information from the
access token. It is called with a single argument: \code{token_info} which is the
access token information returned by the OAuth 2 server after a successful
authentication. The function should return a new \link[=new_user_info]{user_info}
list.}

\item{\code{service_params}}{A named list of additional query params to add to
the url when constructing the authorization url in the
\code{"authorization_code"} grant type}

\item{\code{scopes_delim}}{The separator of the scopes as returned by the service.
The default \code{" "} is the spec recommendation but some services \emph{cough}
github \emph{cough} are non-compliant}

\item{\code{name}}{The name of the guard.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardOAuth2-check_request"></a>}}
\if{latex}{\out{\hypertarget{method-GuardOAuth2-check_request}{}}}
\subsection{Method \code{check_request()}}{
A function that validates an incoming request, returning
\code{TRUE} if it is valid and \code{FALSE} if not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardOAuth2$check_request(request, response, keys, ..., .datastore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{The request to validate as a \link[reqres:Request]{Request}
object}

\item{\code{response}}{The corresponding response to the request as a
\link[reqres:Response]{Response} object}

\item{\code{keys}}{A named list of path parameters from the path matching}

\item{\code{...}}{Ignored}

\item{\code{.datastore}}{The data storage from firesale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardOAuth2-reject_response"></a>}}
\if{latex}{\out{\hypertarget{method-GuardOAuth2-reject_response}{}}}
\subsection{Method \code{reject_response()}}{
Upon rejection this guard initiates the grant flow to obtain
authorization. This can sound a bit backwards, but we don't want to
initiate authorization if the authorization flow doesn't need it
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardOAuth2$reject_response(response, scope, ..., .datastore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{response}}{The response object}

\item{\code{scope}}{The scope of the endpoint}

\item{\code{...}}{Ignored}

\item{\code{.datastore}}{The data storage from firesale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardOAuth2-register_handler"></a>}}
\if{latex}{\out{\hypertarget{method-GuardOAuth2-register_handler}{}}}
\subsection{Method \code{register_handler()}}{
Hook for registering endpoint handlers needed for this
authentication method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardOAuth2$register_handler(add_handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{add_handler}}{The \code{add_handler} method from \link{Fireproof} to be called
for adding additional handlers}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardOAuth2-refresh_token"></a>}}
\if{latex}{\out{\hypertarget{method-GuardOAuth2-refresh_token}{}}}
\subsection{Method \code{refresh_token()}}{
Refresh the access token of the session. Will return \code{TRUE}
upon success and \code{FALSE} upon failure. Failure can either be issues with
the token provider, but also lack of a refresh token.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardOAuth2$refresh_token(session, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{The session data store}

\item{\code{force}}{Boolean. Should the token be refreshed even if it hasn't
expired yet}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardOAuth2-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GuardOAuth2-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardOAuth2$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
