% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guard_oauth2.R
\name{guard_oauth2}
\alias{guard_oauth2}
\title{Guard based on OAuth 2.0}
\usage{
guard_oauth2(
  token_url,
  redirect_url,
  client_id,
  client_secret,
  auth_url = NULL,
  grant_type = c("authorization_code", "password"),
  oauth_scopes = NULL,
  validate = function(info) TRUE,
  redirect_path = get_path(redirect_url),
  on_auth = replay_request,
  user_info = NULL,
  service_params = list(),
  scopes_delim = " ",
  name = "OAuth2Auth"
)
}
\arguments{
\item{token_url}{The URL to the authorization servers token endpoint}

\item{redirect_url}{The URL the authorization server should redirect to
following a successful authorization. Must be equivalent to one provided
when registering your application}

\item{client_id}{The ID issued by the authorization server when
registering your application}

\item{client_secret}{The secret issued by the authorization server when
registering your application. Do NOT store this in plain text}

\item{auth_url}{The URL to redirect the user to when requesting
authorization (only needed for \code{grant_type = "authorization_code"})}

\item{grant_type}{The type of authorization scheme to use, either
\code{"authorization_code"} or \code{"password"}}

\item{oauth_scopes}{Optional character vector of scopes to request the
user to grant you during authorization. These will \emph{not} influence the
scopes granted by the \code{validate} function and fireproof scoping. If named,
the names are taken as scopes and the elements as descriptions of the scopes,
e.g. given a scope, \code{read}, it can either be provided as \code{c("read")} or
\code{c(read = "Grant read access")}}

\item{validate}{Function to validate the user once logged in. It will be
called with a single argument \code{info}, which gets the information of the user
as provided by the \code{user_info} function in the. By default it returns \code{TRUE}
on everything meaning that anyone who can log in with the provider will
be accepted, but you can provide a different function to e.g. restrict
access to certain user names etc. If the function returns a
character vector it is considered to be authenticated and the return value
will be understood as scopes the user is granted.}

\item{redirect_path}{The path that should capture redirects after
successful authorization. By default this is derived from \code{redirect_url}
by removing the domain part of the url, but if for some reason this
doesn't yields the correct result for your server setup you can overwrite
it here.}

\item{on_auth}{A function which will handle the result of a successful
authorization. It will be called with four arguments: \code{request}, \code{response},
\code{session_state}, and \code{server}. The first contains the current request
being responded to, the second is the response being send back, the third
is a list recording the state of the original request which initiated the
authorization (containing \code{method}, \code{url}, \code{headers}, and \code{body} fields
with information from the original request). By default it will use
\link{replay_request} to internally replay the original request and send back
the response.}

\item{user_info}{A function to extract user information from the
access token. It is called with a single argument: \code{token_info} which is the
access token information returned by the OAuth 2 server after a successful
authentication. The function should return a new \link[=new_user_info]{user_info}
list.}

\item{service_params}{A named list of additional query params to add to
the url when constructing the authorization url in the
\code{"authorization_code"} grant type}

\item{scopes_delim}{The separator of the scopes as returned by the service.
The default \code{" "} is the spec recommendation but some services \emph{cough}
github \emph{cough} are non-compliant}

\item{name}{The name of the guard}
}
\value{
A \link{GuardOAuth2} object
}
\description{
OAuth 2.0 is an authorization scheme that is powering much of the modern
internet and is behind things like "log in with GitHub" etc. It separates the
responsibility of authentication away from the server, and allows a user to
grant limited access to a service on the users behalf. While OAuth also
allows a server to make request on the users behalf the main purpose in the
context of \code{fireproof} is to validate that the user can perform a successful
login and potentially extract basic information about the user. The
\code{guard_oauth2()} function is the base constructor which can be used to create
guards with any provider. For ease of use \code{fireproof} comes with a
range of predefined constructors for popular services such as GitHub etc.
Central for all of these is the need for your server to register itself
with the provider and get a client id and a client secret which must be used
when logging users in.
}
\section{User information}{
\code{guard_oauth2()} automatically adds some \link[=new_user_info]{user information} after
authentication, but it is advised to consult the service provider for more
information (this is done automatically for the provider specific
guards. See their documentation for details about what information is
assigned to which field). The base constructor will set the \code{scopes} field to
any scopes returned by the \code{validate} function. It will also set
the \code{token} field to a list with the token data provided by the service
during authorization. Some standard fields in the list are:
\itemize{
\item \code{access_token}: The actual token value
\item \code{token_type}: The type of token (usually \code{"bearer"})
\item \code{expires_in}: The lifetime of the token in seconds
\item \code{refresh_token}: A long-lived token that can be used to issue a new
access token if the current becomes stale
\item \code{timestamp}: The time the token was received
\item \code{scopes}: The scopes granted by the user for this token
}

But OAuth 2.0 providers may choose to supply others. Consult the documentation
for the provider to learn of additional fields it may provide.
}

\examples{
# Example using GitHub endpoints (use `guard_github()` in real code)
github <- guard_oauth2(
  token_url = "https://github.com/login/oauth/access_token",
  redirect_url = "https://example.com/auth",
  client_id = "MY_APP_ID",
  client_secret = "SUCHASECRET",
  auth_url = "https://github.com/login/oauth/authorize",
  grant_type = "authorization_code"
)

# Add it to a fireproof plugin
fp <- Fireproof$new()
fp$add_guard(github, "github_auth")

# Use it in an endpoint
fp$add_auth("get", "/*", github_auth)

}
\references{
\href{https://datatracker.ietf.org/doc/html/rfc6749}{The OAuth 2.0 RFC}
}
