% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top.percent.by.R
\name{top.percent.by}
\alias{top.percent.by}
\title{Subset the top percent of a dataframe by a specific column}
\usage{
top.percent.by(df, percentage, by)
}
\arguments{
\item{df}{A dataframe object as downloaded from GFW's Google Big Data Query.}

\item{percentage}{Number. The 'x' in 'the top x percent of the dataframe'.}

\item{by}{Character. The name of the column for which the percentage will be calculated.}
}
\value{
A dataframe.
}
\description{
Function that sorts a dataframe in descending order for a specific column, calculates the sum of all rows for that column, applies the chosen percentage to said sum, and subsets the minimum number of consecutive rows needed to reach this value.
}
\examples{

dated <- c("2020-01-01", "2020-01-02")
lat <- c(40, 41)
lon <- c(12,13)
mmsi <- c("34534555", "25634555")
hours <- c(0, 5)
fishing_hours <- c(1,9)

df <- data.frame(dated, lat, lon, mmsi, hours, fishing_hours)

who.fishs.the.most <- top.percent.by(df, 90, "fishing_hours")

print(who.fishs.the.most)

}
