% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{generate_fitbitr_token}
\alias{generate_fitbitr_token}
\title{Generate an Oauth token}
\usage{
generate_fitbitr_token(
  app_name = "fitbitr",
  client_id = Sys.getenv("FITBIT_CLIENT_ID"),
  client_secret = Sys.getenv("FITBIT_CLIENT_SECRET"),
  callback = Sys.getenv("FITBIT_CALLBACK", "https://localhost:1410/"),
  scope = c("activity", "cardio_fitness", "electrocardiogram", "heartrate", "location",
    "nutrition", "oxygen_saturation", "profile", "respiratory_rate", "settings", "sleep",
    "social", "temperature", "weight"),
  cache = TRUE,
  use_basic_auth = TRUE,
  ...
)
}
\arguments{
\item{app_name}{The name of your OAuth app. Default: \code{fitbitr}}

\item{client_id}{Your Fitbit client ID}

\item{client_secret}{Your Fitbit client secret}

\item{callback}{Your Fitbit redirect URL}

\item{scope}{The scopes to enable}

\item{cache}{Do you want to cache your token? See \link[httr]{oauth2.0_token} for details}

\item{use_basic_auth}{A boolean for whether or not to use basic auth in \link[httr]{oauth2.0_token}. Defaults to \code{TRUE}}

\item{...}{additional arguments to be passed to \link[httr]{oauth2.0_token}}
}
\value{
Returns an OAuth 2.0 token (invisibly) that can be used to authorize requests to the Fitbit API. Also saves the token to \code{.fitbitr_token}.
}
\description{
Performs the OAuth 2.0 dance to create a token to use with the Fitbit API.
}
\details{
Saves a token as \code{.fitbitr_token} which can then be used in the
background to authorize requests
}
\examples{
\dontrun{
generate_fitbitr_token(
  client_id = <YOUR-CLIENT-ID>
  client_secret = <YOUR-CLIENT-SECRET>,
  cache = TRUE
)
}

}
