% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intraday.R
\name{get_floors_intraday}
\alias{get_floors_intraday}
\title{Get intraday floors time series}
\usage{
get_floors_intraday(
  date = lubridate::today(),
  detail_level = c("1min", "5min", "15min"),
  start_time = NULL,
  end_time = NULL
)
}
\arguments{
\item{date}{A date to get data for}

\item{detail_level}{The detail level. One of \code{"1min"}, \code{"5min"}, or \code{"15min"}}

\item{start_time}{The start time of the time window. Default: \code{NULL} gets the whole day}

\item{end_time}{The end time of the time window. Default: \code{NULL} gets the whole day}
}
\value{
A tibble with two columns: \code{time} and \code{floors}
}
\description{
See the \href{https://dev.fitbit.com/build/reference/web-api/intraday/get-activity-intraday-by-date/}{API documentation} for
more detailed explanations of parameters and more usage information and examples.
}
\examples{
\dontrun{
date <- lubridate::today()

## get minute by minute data
get_floors_intraday(detail_level = "15min")

## get more granular data
get_floors_intraday(detail_level = "1min")
}

}
\seealso{
Other intraday: 
\code{\link{get_active_zone_minutes_intraday}()},
\code{\link{get_calories_intraday}()},
\code{\link{get_distance_intraday}()},
\code{\link{get_elevation_intraday}()},
\code{\link{get_heart_rate_intraday}()},
\code{\link{get_steps_intraday}()}
}
\concept{intraday}
