% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heart-rate.R
\name{get_heart_rate_zones}
\alias{get_heart_rate_zones}
\title{Heart Rate Zones}
\usage{
get_heart_rate_zones(start_date, end_date = start_date)
}
\arguments{
\item{start_date}{The start date of records to be returned in "yyyy-mm-dd" or date(time) format}

\item{end_date}{The end date of records to be returned in "yyyy-mm-dd" or date(time) format}
}
\value{
A tibble of the date, the heart rate zone (\code{zone}), the minimum heart rate in that zone (\code{min_hr}), the maximum heart rate in that zone (\code{max_hr}), the minutes in that zone (\code{minutes_in_zone}), and the calories burned in that zone (\code{calories_out})
}
\description{
See \url{https://dev.fitbit.com/build/reference/web-api/activity/} for more details.
}
\examples{
\dontrun{
start_date <- lubridate::today() - lubridate::weeks(1)
end_date <- lubridate::today()

get_heart_rate_zones(start_date, end_date)
}
}
