% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d_landscape.R
\name{fit_2d_ld}
\alias{fit_2d_ld}
\alias{summary.2d_MVKE_landscape}
\title{Estimate a 2D potential landscape from data with the MVKE method}
\usage{
fit_2d_ld(
  data,
  x,
  lims,
  n = 200L,
  vector_position = "start",
  na_action = "omit_data_points",
  method = c("MVKE"),
  subdivisions = 100L,
  rel.tol = .Machine$double.eps^0.25,
  abs.tol = rel.tol,
  stop.on.error = TRUE,
  keep.xy = FALSE,
  aux = NULL,
  ...
)

\method{summary}{`2d_MVKE_landscape`}(object, ...)
}
\arguments{
\item{data}{A data frame or matrix containing the data. The data frame should contain at least a column, with the column name indicated by \code{x}, that represents the dimension for landscape construction.}

\item{x}{The column name of the data frame that represents the dimension for landscape construction.}

\item{lims}{The limits of the range for the landscape calculation as \code{c(xl, xu)}.}

\item{n}{The number of equally spaced points in the axis, at which the landscape is to be estimated.}

\item{vector_position}{One of "start", "middle", or "end", representing the position of the vectors. If "start", for example, the starting point of a vector is regarded as the position of the vector.}

\item{na_action}{One of "omit_data_points" or "omit_vectors". If using "omit_data_points", then only the \code{NA} points are omitted, and the points before and after an \code{NA} will form a vector. If using "omit_vectors", then the vectors will be omitted if either of its points is \code{NA}.}

\item{method}{The method used to estimate the gradient. Currently only "MVKE" is supported.}

\item{subdivisions}{the maximum number of subintervals.}

\item{rel.tol}{relative accuracy requested.}

\item{abs.tol}{absolute accuracy requested.}

\item{stop.on.error}{logical. If true (the default) an error stops the
    function.  If false some errors will give a result with a warning in
    the \code{message} component.}

\item{keep.xy}{unused.  For compatibility with S.}

\item{aux}{unused.  For compatibility with S.}

\item{...}{Additional arguments passed to \code{\link[=MVKE]{MVKE()}}. (Not used for the \code{summary()} function).}

\item{object}{An object of class \verb{2d_MVKE_landscape} returned by \code{\link[=fit_2d_ld]{fit_2d_ld()}}.}
}
\value{
A \verb{2d_MVKE_landscape} object, which contains the following components:
\itemize{
\item \code{dist}: A data frame containing the estimated potential landscape. The data frame has two columns: \code{x} and \code{U}, where \code{x} is the position and \code{U} is the potential.
\item \code{p}: A ggplot object containing the plot of the potential landscape.
}
}
\description{
This function is a wrapper of the MVKE method (see \code{\link[=MVKE]{MVKE()}}) that produces a 2D potential landscape from 1D data. The landscape is constructed by estimating the gradient of the data and then integrating it. The MVKE method is a non-parametric method that estimates the gradient of the data by using a kernel density estimator. The potential landscape is then constructed by integrating the gradient.
}
\section{Functions}{
\itemize{
\item \code{summary(`2d_MVKE_landscape`)}: Find the local minima of the 2D potential landscape

}}
\examples{
# generate data
single_output_grad <- simlandr::sim_fun_grad(length = 200, seed = 1614)
# fit the landscape
l <- fit_2d_ld(single_output_grad, "x")

summary(l)
plot(l)

# different behaviors for different `na_action` choices

l1 <- fit_2d_ld(data.frame(x = c(1, 2, 1, 2, NA, NA, NA, 10, 11, 10, 11)), "x")
plot(l1)

l2 <- fit_2d_ld(data.frame(x = c(1, 2, 1, 2, NA, NA, NA, 10, 11, 10, 11)), "x",
  na_action = "omit_vectors"
)
plot(l2)

}
