% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_study.R
\name{plot_es}
\alias{plot_es}
\title{Plot Event Study Results}
\usage{
plot_es(
  data,
  ci_level = 0.95,
  type = "ribbon",
  vline_val = 0,
  vline_color = "#000",
  hline_val = 0,
  hline_color = "#000",
  linewidth = 1,
  pointsize = 2,
  alpha = 0.2,
  barwidth = 0.2,
  color = "#B25D91FF",
  fill = "#B25D91FF",
  theme_style = "bw"
)
}
\arguments{
\item{data}{Data frame returned by \code{run_es()}.}

\item{ci_level}{Confidence level for intervals (numeric, e.g. 0.95). Must match columns like 'conf_low_95'.}

\item{type}{Confidence interval style: \code{"ribbon"} (default) or \code{"errorbar"}.}

\item{vline_val}{X value for vertical reference line (default: 0).}

\item{vline_color}{Color for vertical line.}

\item{hline_val}{Y value for horizontal reference line (default: 0).}

\item{hline_color}{Color for horizontal line.}

\item{linewidth}{Width of estimate line or error bars.}

\item{pointsize}{Point size for estimates.}

\item{alpha}{Transparency for ribbon (default: 0.2).}

\item{barwidth}{Width of error bars (if type = "errorbar").}

\item{color}{Color for lines and points.}

\item{fill}{Fill color for ribbon.}

\item{theme_style}{ggplot2 theme: \code{"bw"} (default), \code{"minimal"}, or \code{"classic"}.}
}
\value{
A ggplot2 object.
}
\description{
\code{plot_es()} produces standard event study plots, showing estimated effects and confidence intervals across event time. Supports both ribbon and errorbar styles, multiple confidence levels, and several ggplot2 themes.
}
\details{
Visualizes event study estimates and confidence intervals produced by \code{run_es()}.
}
\examples{
\dontrun{
result <- run_es(...)
plot_es(result, ci_level = 0.95, type = "ribbon")
}

}
\seealso{
\code{\link{run_es}}
}
\author{
Yosuke Abe
}
